const tr = process._linkedBinding("tasklet_runtime");
const vm = require("vm");
const moduleTemplate = tr.getResourceFile("tasklet_module_template.j$");
const modules = new Map();
tr.setTaskletCallback(function(request, callback) {
    try {
        if (!modules.has(request.module)) {
            const source = tr.getResourceFile(request.module);
            const code = moduleTemplate.replace('/*CODE*/', source);
            const initModule = vm.runInThisContext(code);
            const module = { exports: {} };
            initModule(module, module.exports, require, global);
            modules.set(request.module, module);
        }
        const moduleExports = modules.get(request.module).exports;
        const method = moduleExports[request.method];
        method(request.data, function (error, data) {
            callback(error ? String(error) : null, Buffer.isBuffer(data) ? data : null);
        });
    } catch (error) {
        callback(error && error.stack || error, null);
    }
});
