#pragma once

#include "api.h"
#include <contrib/libs/node-addon-api/napi.h>
#include <library/cpp/threading/future/future.h>
#include <util/generic/singleton.h>
#include <util/generic/string.h>
#include <util/generic/strbuf.h>
#include <util/thread/factory.h>
#include <util/system/guard.h>
#include <util/system/spinlock.h>

namespace NTasklet::NJS {

using NThreading::TFuture;
using NThreading::TPromise;

using TResultPromise = TPromise<TResult>;

class TRuntime {
private:
    Y_DECLARE_SINGLETON_FRIEND();
    TRuntime();
    THolder<IThreadFactory::IThread> NodeMainThread_;
    TAdaptiveLock StopLock_;
    TPromise<void> JavaScriptInitialization_;
    Napi::ThreadSafeFunction JavaScriptHandler_;
public:
    ~TRuntime();
    TRuntime(const TRuntime&) = delete;
    TRuntime& operator=(const TRuntime&) = delete;

    static inline TRuntime* GetInstance() {
        return Singleton<TRuntime>();
    }

    void SetJavaScriptHandler(const Napi::ThreadSafeFunction&);
    TFutureResult CallJavaScript(const TStringBuf &module, const TStringBuf &method, const TStringBuf &data);
    void Stop();
};

}
