#pragma once

#include "wrapper.h"

#include <tasklet/api/tasklet.pb.h>
#include <tasklet/gen/lib/names.h>

#include <util/generic/yexception.h>

namespace NTasklet {

template <class Impl>
class TCppWrapper : public IWrapper {
public:
    TString ImplClassPath() override {
        const ::google::protobuf::Descriptor* descriptor = Impl::TTaskletMessage::descriptor();
        return NTaskletGen::BaseTaskletModuleName(descriptor->file()) + ":" +
            NTaskletGen::BaseTaskletClassName(descriptor);
    }

    TString GetTaskletName() override {
        const ::google::protobuf::Descriptor* descriptor = Impl::TTaskletMessage::descriptor();
        return TString(descriptor->name());
    }

    TMaybe<TString> Execute(const TString& data) override {
        tasklet::JobInstance job;
        if (!job.ParseFromString(data)) {
            ythrow yexception() << "Invalid request";
        }

        typename Impl::TInputMessage input;
        job.statement().input().UnpackTo(&input);

        typename Impl::TOutputMessage output;

        Impl impl;
        impl.TaskletId = job.id();
        impl.Run(input, output);

        tasklet::JobResult response;
        response.mutable_output()->PackFrom(output);
        response.set_success(true);

        return TMaybe<TString>(response.SerializeAsString());
    }

    TMaybe<TString> GetInitDescription(const TString& data) override {
        tasklet::JobStatement job;
        if (!job.ParseFromString(data)) {
            ythrow yexception() << "Invalid request";
        }

        typename Impl::TInputMessage input, tempInput;
        Impl impl;

        job.input().UnpackTo(&tempInput);
        impl.SetupDefaultInput(input);
        input.MergeFrom(tempInput);

        tasklet::Requirements reqResponse;
        TString reqResponseStr, jobStr;
        impl.SetupRequirements(input, reqResponse);
        Y_PROTOBUF_SUPPRESS_NODISCARD reqResponse.SerializeToString(&reqResponseStr);

        job.mutable_input()->PackFrom(input);
        if (reqResponseStr) {
            job.mutable_requirements()->CopyFrom(reqResponse);
        }

        Y_PROTOBUF_SUPPRESS_NODISCARD job.SerializeToString(&jobStr);

        return TMaybe<TString>(jobStr);
    }
};

}
