#pragma once

#include "dispatch.h"

#include <tasklet/api/tasklet.pb.h>

#include <util/generic/yexception.h>

namespace NTasklet {

template<class Input, class Output>
Output Execute(const TString& name, const Input& input) {
    tasklet::JobStatement request;
    request.set_name(name);
    request.mutable_input()->PackFrom(input);

    TString responseString = Execute(request.SerializeAsString());

    tasklet::JobResult response;
    if (!response.ParseFromString(responseString)) {
        ythrow yexception() << "Invalid response";
    }

    Output output;
    response.output().UnpackTo(&output);
    return output;
}

} // namespace NTasklet
