#include "java_wrapper.h"

#define PY_SSIZE_T_CLEAN // for support '#' formats
#include <Python.h>

// NOT COMPLETE
namespace NTasklet {
    TJavaWrapper::TJavaWrapper(const TStringBuf& javaImpl, const TStringBuf& pythonImpl)
        : JavaImpl(javaImpl), PythonImpl(pythonImpl)
    {
    }

    TString TJavaWrapper::ImplClassPath() {
        return TString(PythonImpl.data(), PythonImpl.length());
    }

    TMaybe<TString> TJavaWrapper::GetInitDescription(const TString& data) {
        return CallPyHelper("get_init_description", data);
    }

    TString TJavaWrapper::GetTaskletName() {
        return TString(JavaImpl.data(), JavaImpl.length());
    }

    TMaybe<TString> TJavaWrapper::Execute(const TString& data) {
        return CallPyHelper("execute_helper", data);
    }

    TMaybe<TString> TJavaWrapper::CallPyHelper(const char* method, const TString& data) {
        TMaybe<TString> response;

        PyObject* module = PyImport_ImportModule("tasklet.runtime");
        if (module == nullptr) {
            PyErr_Print();
        } else {
            PyObject* value = PyObject_CallMethod(
                module,
                const_cast<char*>(method),
                const_cast<char*>(PY_MAJOR_VERSION == 3 ? "y#:y#" : "s#s#"),
                PythonImpl.data(), PythonImpl.length(),
                data.data(), data.length()
            );

            if (value == nullptr) {
                PyErr_Print();
            } else {
                char* str = PyBytes_AsString(value);
                if (str == nullptr) {
                    PyErr_Print();
                } else {
                    response = TString(str, PyBytes_Size(value));
                    if (PyBytes_Size(value) == 0) {
                        response = "";
                    }
                }

                Py_DECREF(value);
            }

            Py_DECREF(module);
        }

        return response;
    }
}
