#include "js_wrapper.h"
#include <tasklet/runtime/js/api.h>
#include <tasklet/gen/lib/names.h>
#include <tasklet/api/tasklet.pb.h>
#include <util/string/split.h>

namespace NTasklet {

using NThreading::TFuture;

static const TStringBuf JS_FN_GET_TASKLET_NAME = "getTaskletName";
static const TStringBuf JS_FN_IMPL_CLASS_PATH = "getPythonProtoImportPath";
static const TStringBuf JS_FN_GET_INIT_DESCRIPTION = "getInitialDescription";
static const TStringBuf JS_FN_EXECUTE = "execute";

TJsWrapper::TJsWrapper(const TStringBuf& registryData)
    : RegistryData(registryData)
{
    const auto& ss = StringSplitter(registryData).Split('@').Limit(2);
    TVector<TString> v { ss.begin(), ss.end() };
    Y_ASSERT(v.size() == 2);
    JSModule = v[1];
}

inline NJS::TResult TJsWrapper::CallSync(const TStringBuf& name, const TStringBuf& data) {
    const auto& f = NJS::CallJavaScript(JSModule, name, data);
    f.Wait();
    return f.GetValueSync();
}

TString TJsWrapper::GetTaskletName() {
    return CallSync(JS_FN_GET_TASKLET_NAME, RegistryData);
}

TString TJsWrapper::ImplClassPath() {
    // TODO: get proto class name from JS code, which could get it from generated by protoc JS code
    return CallSync(JS_FN_IMPL_CLASS_PATH, RegistryData);
}

TMaybe<TString> TJsWrapper::GetInitDescription(const TString& data) {
    return CallSync(JS_FN_GET_INIT_DESCRIPTION, data);
}

TMaybe<TString> TJsWrapper::Execute(const TString& data) {
    return CallSync(JS_FN_EXECUTE, data);
}

}
