#pragma once

#include <tasklet/runtime/lib/wrapper.h>
#include <library/cpp/threading/future/future.h>
#include <util/generic/maybe.h>
#include <util/generic/strbuf.h>
#include <util/generic/string.h>

namespace NTasklet {
    class TJsWrapper : public IWrapper {
    public:
        TJsWrapper(const TStringBuf&);

        TString ImplClassPath() override;
        TString GetTaskletName() override;
        TMaybe<TString> Execute(const TString&) override;
        TMaybe<TString> GetInitDescription(const TString&) override;
    private:
        TString RegistryData;
        TString JSModule;
        NThreading::TFuture<TString> ScheduleCall(const TStringBuf& name, const TStringBuf& data);
        TString CallSync(const TStringBuf& name, const TStringBuf& data);
    };
}
