#include "py_wrapper.h"

#define PY_SSIZE_T_CLEAN // for support '#' formats
#include <Python.h>

namespace NTasklet {
    TPythonWrapper::TPythonWrapper(const TStringBuf& impl)
        : Impl(impl)
    {
    }

    TString TPythonWrapper::ImplClassPath() {
        return TString(Impl.data(), Impl.length());
    }

    TMaybe<TString> TPythonWrapper::GetInitDescription(const TString& data) {
        return CallPyHelper("get_init_description", data);
    }

    TString TPythonWrapper::GetTaskletName() {
        return TString(*CallPyHelper("get_tasklet_name", TString("")));
    }

    TMaybe<TString> TPythonWrapper::Execute(const TString& data) {
        return CallPyHelper("execute_helper", data);
    }

    TMaybe<TString> TPythonWrapper::CallPyHelper(const char* method, const TString& data) {
        TMaybe<TString> response;

        PyObject* module = PyImport_ImportModule("tasklet.runtime");
        if (module == nullptr) {
            PyErr_Print();
        } else {
            PyObject* value = PyObject_CallMethod(
                module,
                const_cast<char*>(method),
                const_cast<char*>(PY_MAJOR_VERSION == 3 ? "y#:y#" : "s#s#"),
                Impl.data(), Impl.length(),
                data.data(), data.length()
            );

            if (value == nullptr) {
                PyErr_Print();
            } else {
                char* str = PyBytes_AsString(value);
                if (str == nullptr) {
                    PyErr_Print();
                } else {
                    response = TString(str, PyBytes_Size(value));
                    if (PyBytes_Size(value) == 0) {
                        response = "";
                    }
                }

                Py_DECREF(value);
            }

            Py_DECREF(module);
        }

        return response;
    }
}
