#pragma once

#include "wrapper.h"

#include <util/generic/maybe.h>
#include <util/generic/strbuf.h>

namespace NTasklet {
    class TPythonWrapper : public IWrapper {
    public:
        TPythonWrapper(const TStringBuf& impl);

        TString ImplClassPath() override;
        TString GetTaskletName() override;
        TMaybe<TString> Execute(const TString& data) override;
        TMaybe<TString> GetInitDescription(const TString& data) override;

    private:
        TStringBuf Impl;
        TMaybe<TString> CallPyHelper(const char* method, const TString& data);
    };
}
