#include "registry.h"
#include "wrapper.h"

#include <util/generic/singleton.h>
#include <util/generic/vector.h>


namespace NTasklet {
    void TRegistry::Store(const TStringBuf& name, IWrapper* wrapper) {
        Y_VERIFY(!Wrappers.contains(name), "Implementation with name '%s' is already registered", name.data());
        Wrappers[name] = wrapper;
    }

    void TRegistry::Initialize() {
        NameToImpl.clear();
        for (const auto& wrapper: Wrappers) {
            NameToImpl[wrapper.second->GetTaskletName()].push_back(wrapper.first);
        }
    }

    IWrapper* TRegistry::Find(const TStringBuf& name) const {
        auto it = Wrappers.find(name);
        if (it == Wrappers.end()) {
            return nullptr;
        } else {
            return it->second;
        }
    }

    const TVector<TStringBuf>& TRegistry::FindImpl(const TStringBuf& name) {
        return NameToImpl[name];
    }

    const TVector<TString> TRegistry::ListTaskletNames() const {
        TVector<TString> keys;
        for (const auto& entry: NameToImpl) {
            keys.push_back(entry.first);
        }
        return keys;
    }

    TRegistry* Registry() {
        return Singleton<TRegistry>();
    }
}
