#pragma once

#include "wrapper.h"

#include <util/generic/hash.h>

namespace NTasklet {
    class TRegistry {
    public:
        void Store(const TStringBuf& name, IWrapper* wrapper);
        void Initialize();

        IWrapper* Find(const TStringBuf& name) const;
        const TVector<TStringBuf>& FindImpl(const TStringBuf& name);
        const TVector<TString> ListTaskletNames() const;
    private:
        THashMap<TStringBuf, IWrapper*> Wrappers;
        THashMap<TString, TVector<TStringBuf>> NameToImpl;
    };

    TRegistry* Registry();

    struct TRegHelper {
        inline TRegHelper(const TStringBuf& name, IWrapper* wrapper) {
            Registry()->Store(name, wrapper);
        }
    };
}
