#pragma once

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NTasklet {
    class IWrapper {
    public:
        virtual ~IWrapper() = default;

        virtual TString ImplClassPath() = 0;
        virtual TString GetTaskletName() = 0;
        virtual TMaybe<TString> Execute(const TString& data) = 0;
        virtual TMaybe<TString> GetInitDescription(const TString& data) = 0;
    };
}
