import importlib
import uuid

from google.protobuf import json_format

MAX_MESSAGE_LEN = 100


def import_symbol(full_path):
    """ Imports symbol from module by path '<import path to module>:<symbol name>' """
    mod_name, type_name = full_path.split(":", 1)
    mod = importlib.import_module(mod_name)
    return getattr(mod, type_name)


def symbol_path(symbol):
    return "{}:{}".format(symbol.__module__, symbol.__name__)


def generate_tasklet_id():
    return str(uuid.uuid4())


def generate_run_id():
    return str(uuid.uuid4())


def message_repr(empty_message, message):
    message.Unpack(empty_message)
    message_str = json_format.MessageToJson(empty_message)
    if len(message_str) > MAX_MESSAGE_LEN:
        message_str = "Long message ({} symbols)".format(len(message_str))
    return message_str
