MAX_FIELD_DEPTH_ALLOWED = 8

from google.protobuf import descriptor


def proto_to_flat_dict(msg):
    dct = {}
    for params_field in msg.DESCRIPTOR.fields:
        _proto_field_to_flat_dict(dct, msg, params_field)
    return dct


def _proto_field_to_flat_dict(dct, msg, field_descriptor, prefix='', depth=0):
    full_field_name = '{}__{}'.format(prefix, field_descriptor.name) if prefix else field_descriptor.name
    field = getattr(msg, field_descriptor.name)
    if field_descriptor.message_type is not None:
        if not field.ByteSize():
            return

        if depth >= MAX_FIELD_DEPTH_ALLOWED:
            raise Exception(
                'Max fields nesting depth {} exceeded for field {}. Check possible nested fields recursion.'.
                format(MAX_FIELD_DEPTH_ALLOWED, field_descriptor.full_name)
            )

        for subfield in field_descriptor.message_type.fields:
            _proto_field_to_flat_dict(dct, field, subfield, full_field_name, depth + 1)
    elif _is_repeated(field_descriptor):
        dct[full_field_name] = list(field)
    else:
        dct[full_field_name] = field


def flat_dict_to_proto(dct, msg):
    fields_not_found = []
    for name, value in dct.items():
        if not _flat_dict_field_to_proto(msg, name, value):
            fields_not_found.append(name)
    return fields_not_found


def _flat_dict_field_to_proto(msg, full_field_name, value):
    current_level_msg = msg

    full_name_parts = full_field_name.split('__')
    for i, field_name in enumerate(full_name_parts):

        field_descriptor = current_level_msg.DESCRIPTOR.fields_by_name.get(field_name)

        if field_descriptor is None:
            return False
        elif field_descriptor.message_type is None:
            if i == len(full_name_parts) - 1:
                if value is not None:
                    if _is_repeated(field_descriptor):
                        getattr(current_level_msg, field_name).extend(value)
                    else:
                        setattr(current_level_msg, field_name, value)
                return True
            else:
                return False
        else:
            current_level_msg = getattr(current_level_msg, field_name)

    return False


def _is_repeated(field_descriptor):
    return field_descriptor.label == descriptor.FieldDescriptor.LABEL_REPEATED
