package ru.yandex.tasklet;

import javax.annotation.Nullable;

import com.google.common.base.Preconditions;

class InputOutputSettings {
    private final String serviceAddress;
    private final String inputFileReference;
    private final String outputFileReference;
    @Nullable // So far. Waiting for tasklet bootstrap support
    private final String errorFileReference;

    InputOutputSettings(
            String serviceAddress,
            String inputFileReference,
            String outputFileReference,
            String errorFileReference
    ) {
        this.serviceAddress = serviceAddress;
        this.inputFileReference = inputFileReference;
        this.outputFileReference = outputFileReference;
        this.errorFileReference = errorFileReference;
    }

    public String getServiceAddress() {
        return serviceAddress;
    }

    public String getInputFileReference() {
        return inputFileReference;
    }

    public String getOutputFileReference() {
        return outputFileReference;
    }

    @Nullable
    public String getErrorFileReference() {
        return errorFileReference;
    }

    public static InputOutputSettings parse(String[] args) {
        Preconditions.checkArgument(args != null, "args cannot be null");
        Preconditions.checkArgument(args.length >= 3,
                "Invalid command line arguments, must be: service.address input.file output.file [error.file]");

        return new InputOutputSettings(
                args[0],
                args[1],
                args[2],
                args.length > 3
                        ? args[3]
                        : null
        );
    }
}
