package ru.yandex.tasklet;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;

import ru.yandex.tasklet.api.v2.WellKnownStructures.UserError;

public class Result<R extends Message> {
    private final UserError error;
    private final R result;

    private Result(UserError error, R result) {
        this.result = result;
        this.error = error;
    }

    public boolean hasResult() {
        return result != null;
    }

    public boolean hasError() {
        return error != null;
    }

    public R getResult() {
        Preconditions.checkState(hasResult(), "instance is configured with error");
        return result;
    }

    public UserError getError() {
        Preconditions.checkState(hasError(), "instance is configured with result");
        return error;
    }

    public static <R extends Message> Result<R> of(R result) {
        Preconditions.checkArgument(result != null, "result cannot be null");
        return new Result<>(null, result);
    }

    public static <R extends Message> Result<R> ofError(UserError error) {
        Preconditions.checkArgument(error != null, "error cannot be null");
        return new Result<>(error, null);
    }
}
