import logging
import socket
import threading

from six.moves import BaseHTTPServer

from google.protobuf import empty_pb2

from tasklet import runtime
from tasklet.runtime import utils

from tasklet.api import tasklet_pb2

from .proto import server_pb2, server_pb2_grpc

from . import graph_helper


logger = logging.getLogger(__name__)


def cons_server():
    s = tasklet_pb2.LocalService()
    s.register = utils.symbol_path(server_pb2_grpc.add_ServerServicer_to_server)
    s.impl = utils.symbol_path(ServerService)
    s.client = utils.symbol_path(server_pb2_grpc.ServerStub)
    return s


def cons_server_cli():
    entry = tasklet_pb2.ContextEntry()
    entry.name = 'server'
    entry.any.Pack(cons_server())
    return entry


class HTTPServerV6(BaseHTTPServer.HTTPServer):
    address_family = socket.AF_INET6


class ServerService(object):
    server_running = False

    def __init__(self):
        self.run_id = None
        self.spy = None
        self.thread = None

    def GetContext(self, request, context):
        return server_pb2.ServerContext()

    def Inject(self, request, context):
        runtime.inject(request, self)
        if self.server_running:
            return empty_pb2.Empty()

        self.server_running = True

        class Handler(BaseHTTPServer.BaseHTTPRequestHandler):
            def do_GET(inner_self):
                inner_self.send_response(200)
                # inner_self.send_header("Content-type", "image/svg+xml")
                inner_self.end_headers()

                inner_self.wfile.write(graph_helper.draw_graph(self.spy.query().events, self.run_id))

        server = HTTPServerV6(('::', 0), Handler)

        self.thread = threading.Thread(target=server.serve_forever)
        self.thread.setDaemon(True)
        self.thread.start()

        sa = server.socket.getsockname()
        logger.info('http://localhost:{}'.format(sa[1]))

        return empty_pb2.Empty()
