import os
import shutil

from tasklet.experimental.sdk.py.dummy import interface as dummy_sdk

from sandbox.tasklet.sidecars.resource_manager.proto import resource_manager_api_pb2 as sbr_api_pb2
from sandbox.tasklet.sidecars.resource_manager.proto import resource_manager_api_pb2_grpc as sbr_api_pb2_grpc

from tasklet.tasklets.lifecycle.internal import arc as internal_arc
from tasklet.tasklets.lifecycle.internal import ya
from tasklet.tasklets.lifecycle.internal import os as internal_os
from tasklet.tasklets.lifecycle.internal import routine
from tasklet.tasklets.lifecycle.internal import sbr
from tasklet.tasklets.lifecycle.internal import tasklet_tool

from tasklet.tasklets.lifecycle.proto import build_tasklet_pb2
from tasklet.tasklets.lifecycle.proto import data_models_pb2

from tasklet.tasklets.lifecycle.internal import register

DEFAULT_PROTO_REGISTRY_BUILD_RESULT = "tasklet/registry/common/tasklet-registry-common.protodesc"
DEFAULT_TASKLET_SB_RESOURCE_TYPE = "TASKLET_EXECUTABLE"


def do_make_target(
    details: build_tasklet_pb2.MakeDetails, arc: internal_arc.Arc, ya_tool: ya.YaTool, results_path: str,
) -> str:

    with internal_os.ChangeDir(arc.mount_path):
        path = ya_tool.make(details, arc.mount_path)

    return shutil.copy2(path, results_path)


def do_register_result_resource(
    sbr_client: sbr_api_pb2_grpc.ResourceManagerAPIStub,
    resource_path: str,
    cfg: build_tasklet_pb2.MakeResultDetails,
) -> data_models_pb2.SandboxResourceRef:

    response: sbr_api_pb2.CreateResourceResponse = sbr_client.CreateResource(
        sbr_api_pb2.CreateResourceRequest(
            path=resource_path,
            type=cfg.resource_type or DEFAULT_TASKLET_SB_RESOURCE_TYPE,
            attributes=cfg.attributes,
            description="",
        ),
    )

    res = response.resource
    return data_models_pb2.SandboxResourceRef(
        id=res.id,
        type=res.type,
        owner=res.owner,
        task_id=res.task,
    )


def main():
    routine.base_init()
    tasklet_io = dummy_sdk.TaskletInterface()

    request = build_tasklet_pb2.BuildTaskletInput()
    tasklet_io.read_input(request)

    src_opts = request.src
    arc: internal_arc.Arc = internal_arc.get_arc(tasklet_io, src_opts.arc_token)

    results_path = os.path.join(os.getcwd(), "results")
    os.makedirs(results_path)

    with arc.mount():
        ya_tool = ya.YaTool(arc.mount_path)

        with internal_os.ChangeDir(arc.mount_path):
            arc.checkout(src_opts.commit_or_branch)

        sbr_client = sbr.get_sbr_client(tasklet_io.get_context())

        tasklet_path = do_make_target(request.make, arc, ya_tool, results_path)
        tasklet_sbr_ref = do_register_result_resource(sbr_client, tasklet_path, request.make_result)

        schema_path = do_make_target(request.schema, arc, ya_tool, results_path)
        schema_sbr_ref = do_register_result_resource(sbr_client, schema_path, request.schema_result)

        ttool = tasklet_tool.get_tasklet_tool(tasklet_io, request.tasklet_token, request.register_build.tasklet_cluster)
        build = register.do_register_build(ttool, request.register_build, tasklet_sbr_ref, schema_path, arc.mount_path)

    output = build_tasklet_pb2.BuildTaskletOutput(
        build_resource=tasklet_sbr_ref,
        schema_resource=schema_sbr_ref,
        build=build,
    )
    tasklet_io.write_output(output)


if __name__ == "__main__":
    main()
