import logging
import os
import subprocess as sp
import time


def run_command(logger: logging.Logger, args: list, **kwargs) -> sp.Popen:
    started_at = time.time()
    p = sp.Popen(args, **kwargs)
    logger.debug("[pid=%s] Command started: %s", p.pid, args)
    p.wait()
    logger.debug(
        "[pid=%s] Command finished with return code %s. Duration: %.3ss",
        p.pid, p.returncode, time.time() - started_at,
    )
    return p


class ChangeDir:

    def __init__(self, target_dir):
        self.__cwd_stack = []
        self.__cwd = ""
        self.__call__(target_dir)

    def __call__(self, target_dir):
        self.__cwd = target_dir

    def __enter__(self):
        self.__cwd_stack.append(os.getcwd())
        os.chdir(self.__cwd)

    def __exit__(self, *_):
        self.__cwd = self.__cwd_stack.pop()
        os.chdir(self.__cwd)
