import os


class TaskletPaths:

    DEFAULT_YAML_NAME = "t.yaml"

    def __init__(self, arcadia_path: str, spec_path: str):
        self.__arcadia_path = arcadia_path

        spec_path = os.path.join(arcadia_path, spec_path)
        if os.path.isdir(spec_path):
            spec_path = os.path.join(spec_path, self.DEFAULT_YAML_NAME)
        if not os.path.isfile(spec_path):
            raise ValueError(f"There is no tasklet specification with path {spec_path}")

        self.spec_path = spec_path

    @property
    def spec_dir(self):
        return os.path.dirname(self.spec_path)
