from tasklet.api.v2 import data_model_pb2 as api_model_pb2

from tasklet.tasklets.lifecycle.internal import os as internal_os
from tasklet.tasklets.lifecycle.internal import path as internal_path
from tasklet.tasklets.lifecycle.internal import tasklet_tool

from tasklet.tasklets.lifecycle.proto import data_models_pb2


def do_register_build(
    ttool: tasklet_tool.TaskletTool,
    details: data_models_pb2.RegisterBuildDetails,
    build_resource_ref: data_models_pb2.SandboxResourceRef,
    schema_path: str,
    arcadia_root: str,
) -> api_model_pb2.Build:

    schema_id = ttool.register_schema(schema_path).hash
    paths = internal_path.TaskletPaths(arcadia_root, details.t_yaml_path)
    with internal_os.ChangeDir(paths.spec_dir):
        build = ttool.register_build(build_resource_ref.id, schema_id)
        if details.label_name:
            ttool.move_label(details.label_name, build.meta.id)

    return build
