import logging
import os


def setup_logging():
    logging.root.setLevel(logging.DEBUG)

    handler = logging.StreamHandler()
    formatter = logging.Formatter("%(asctime)s %(levelname)-7s (%(name)s) %(message)s")
    handler.setFormatter(formatter)

    logging.root.handlers = []
    logging.root.addHandler(handler)


def base_init():
    setup_logging()

    env_vars = [f"{name}={value}" for name, value in sorted(os.environ.items())]
    logging.debug("Environmental variables:\n%s", "\n".join(env_vars))
