import grpc

from sandbox.tasklet.sidecars.resource_manager.proto import resource_manager_api_pb2_grpc as sbr_api_pb2_grpc

from tasklet.api.v2 import context_pb2


def get_sbr_client(context: context_pb2.Context) -> sbr_api_pb2_grpc.ResourceManagerAPIStub:
    address: str = context.environment.sandbox_resource_manager.address
    if not address:
        raise EnvironmentError("SBR manager address is not provided. Did you forget to add the appropriate sidecar?")
    return sbr_api_pb2_grpc.ResourceManagerAPIStub(grpc.insecure_channel(address))
