from typing import List

import logging
import os

from tasklet.tasklets.lifecycle.proto import build_tasklet_pb2

from tasklet.tasklets.lifecycle.internal import os as internal_os


class YaTool:

    def __init__(self, arc_path: str, logger: logging.Logger = None):
        self.__path = os.path.join(arc_path, "ya")
        if logger is None:
            logger = logging.getLogger("ya-tool")
        self.logger = logger

    def cmd(self, args: List[str]) -> List[str]:
        return ["/usr/bin/python3", self.__path] + args

    def make(self, details: build_tasklet_pb2.MakeDetails, arcadia_path: str) -> str:
        target_path = os.path.join(arcadia_path, details.target)
        args = ["make", target_path]
        if details.extra_args:
            args.extend(details.extra_args)
        p = internal_os.run_command(self.logger, self.cmd(args))
        if p.returncode:
            raise RuntimeError("Failed to build tasklet")

        file_name = details.file_name
        if not file_name:
            file_name = os.path.basename(details.target.rstrip(os.sep))
            self.logger.debug("file_name is not provided, try '%s'", file_name)
        file_path = os.path.join(target_path, file_name)
        if not os.path.exists(file_path):
            raise RuntimeError(f"There is no make result with path {file_path}")
        return file_path
