from tasklet.experimental.sdk.py.dummy import interface as dummy_sdk

from tasklet.tasklets.lifecycle.internal import arc as internal_arc
from tasklet.tasklets.lifecycle.internal import os as internal_os
from tasklet.tasklets.lifecycle.internal import path as internal_path
from tasklet.tasklets.lifecycle.internal import routine
from tasklet.tasklets.lifecycle.internal import tasklet_tool

from tasklet.tasklets.lifecycle.proto import move_label_pb2


def main():
    routine.base_init()
    tasklet_io = dummy_sdk.TaskletInterface()

    request = move_label_pb2.MoveLabelInput()
    tasklet_io.read_input(request)

    src_opts = request.src
    arc: internal_arc.Arc = internal_arc.get_arc(tasklet_io, src_opts.arc_token)

    with arc.mount():
        with internal_os.ChangeDir(arc.mount_path):
            arc.checkout(src_opts.commit_or_branch)

        ttool = tasklet_tool.get_tasklet_tool(tasklet_io, request.tasklet_token, request.details.tasklet_cluster)

        paths = internal_path.TaskletPaths(arc.mount_path, request.details.t_yaml_path)
        with internal_os.ChangeDir(paths.spec_dir):
            label = ttool.move_label(request.details.label_name, request.details.build_id)

    output = move_label_pb2.MoveLabelOutput(label=label)
    tasklet_io.write_output(output)


if __name__ == "__main__":
    main()
