from tasklet.experimental.sdk.py.dummy import interface as dummy_sdk

from sandbox.tasklet.sidecars.resource_manager.proto import resource_manager_api_pb2 as sbr_api_pb2

from tasklet.tasklets.lifecycle.internal import arc as internal_arc
from tasklet.tasklets.lifecycle.internal import os as internal_os
from tasklet.tasklets.lifecycle.internal import register
from tasklet.tasklets.lifecycle.internal import routine
from tasklet.tasklets.lifecycle.internal import sbr
from tasklet.tasklets.lifecycle.internal import tasklet_tool

from tasklet.tasklets.lifecycle.proto import register_build_pb2


def main():
    routine.base_init()
    tasklet_io = dummy_sdk.TaskletInterface()

    request = register_build_pb2.RegisterBuildInput()
    tasklet_io.read_input(request)

    src_opts = request.src
    arc: internal_arc.Arc = internal_arc.get_arc(tasklet_io, src_opts.arc_token)

    with arc.mount():
        with internal_os.ChangeDir(arc.mount_path):
            arc.checkout(src_opts.commit_or_branch)

        ttool = tasklet_tool.get_tasklet_tool(tasklet_io, request.tasklet_token, request.register_build.tasklet_cluster)

        sbr_client = sbr.get_sbr_client(tasklet_io.get_context())
        schema_resource: sbr_api_pb2.DownloadResourceResponse = sbr_client.DownloadResource(
            sbr_api_pb2.DownloadResourceRequest(id=request.schema_resource.id),
        )

        build = register.do_register_build(
            ttool, request.register_build, request.build_resource, schema_resource.path, arc.mount_path,
        )

    output = register_build_pb2.RegisterBuildOutput(build=build)
    tasklet_io.write_output(output)


if __name__ == "__main__":
    main()
