# coding=utf-8

"""
Скрипт используется для генерации файлов пакета при сборке ya make.
"""

import argparse
import os
import subprocess
import sys
import warnings
import shutil

parser = argparse.ArgumentParser()
parser.add_argument('--node-bin', type=str, help='node binary', required=True)
parser.add_argument('--protoc-bin', type=str, help='protoc binary', required=True)
parser.add_argument('--build-dir', type=str, help='target build directory', required=True)
parser.add_argument('--proto-targets',
    type=str, help='list of the proto libraries targets (absolute paths)', required=True)
parser.add_argument('--proto-relative-output',
    type=str, help='protoc output directory relative to entry point', required=True)
parser.add_argument('--proto-paths', type=str, help='list of the proto import paths (absolute)', required=True)
parser.add_argument('--entry-point', type=str, help='JS file that provides the tasklet implementation', required=True)
parser.add_argument('--output-proto',
    type=str, help='destination dir in the source tree to place a copy of JS generated by protoc')
parser.add_argument('--output-bundle', type=str, help='path to the output JS bundle file', required=True)
args = parser.parse_args()

def get_protos(proto_targets_dirs):
    def find_protos(dir_):
        if dir_.endswith("tasklet/api/v2"):
            # NB: do not include v2 API. This is v1 tasklet.
            return []
        if os.path.isfile(dir_):
            if dir_.find('.proto') is not -1:
                return [dir_]
            else:
                return []

        files = list()
        for filename in os.listdir(dir_):
            files.extend(find_protos(os.path.join(dir_, filename)))

        return files

    proto_paths = list()
    for proto_dir in proto_targets_dirs:
        proto_paths.extend(find_protos(proto_dir))

    proto_paths.sort()
    return proto_paths

def assert_exists(tool_path):
    if not os.path.exists(tool_path):
        warnings.warn('not found {}'.format(tool_path))
        sys.exit(1)

def run_cmd(cmd, cwd):
    env = os.environ.copy()
    res = subprocess.Popen(
        cmd,
        cwd=cwd,
        env=env,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        shell=True
    )
    print('cmd:\n{}'.format(cmd))

    res.wait()

    stdout = res.stdout.read().strip()
    stderr = res.stderr.read().strip()
    print('stdout:\n{}'.format(stdout))

    if res.returncode:
        warnings.warn('command execution failed')
        warnings.warn('command:\n\n{}\n'.format(cmd))
        warnings.warn('stderr: \n\n{}\n'.format(stderr))
        sys.exit(res.returncode)
    else:
        print('stderr:\n{}'.format(stderr))

build_dir = args.build_dir
proto_output_dir = '{}/{}'.format(build_dir, args.proto_relative_output)

if not os.path.exists(proto_output_dir):
    os.mkdir(proto_output_dir)

src_proto_abs_paths = get_protos(args.proto_targets.split(':'))
import_proto_paths_params = map(lambda p: '--proto_path={}'.format(p), args.proto_paths.split(':'))

run_cmd(' '.join(
    [
        args.protoc_bin,
        '--js_out=import_style=commonjs,binary:{}'.format(proto_output_dir),
    ] \
    + import_proto_paths_params \
    + src_proto_abs_paths
), build_dir)

build_entry_point = os.path.join(build_dir, os.path.basename(args.entry_point))
shutil.copyfile(args.entry_point, build_entry_point)

run_cmd(' '.join(
    [
        args.node_bin,
        os.path.join(args.build_dir, 'node_modules', 'browserify', 'bin', 'cmd.js'),
        '--node',
        '--standalone', 'tasklet',
        '-o', args.output_bundle,
        build_entry_point
    ]
), build_dir)

if args.output_proto:
    if os.path.exists(args.output_proto):
        shutil.rmtree(args.output_proto)
    shutil.copytree(proto_output_dir, args.output_proto)

