PY23_LIBRARY()

OWNER(g:tasklet)

TASKLET_REG(CompareTask js tasklet.tests.proto.tasks_tasklet:CompareTaskBase@tasklet.bundle.js)

RESOURCE(
    tasklet.bundle.js tasklet.bundle.js
)

PEERDIR(
    tasklet/api
    tasklet/tests/proto
)

# Following macroses manages JS dependencies in Arcadia way
# and produces the JS bundle including the tasklet source code and all the dependencies.

INCLUDE(dependencies.inc)
INCLUDE(dependencies.lst)

SET(SOURCE_DIR ${ARCADIA_ROOT}/tasklet/tests/js)
SET(BUILD_DIR ${ARCADIA_BUILD_ROOT}/tasklet/tests/js)
SET(NODE contrib/libs/nodejs_12)
SET(PROTOC contrib/tools/protoc)
SET(NODE_MODULES_OUT resource.tar.gz)

FROM_SANDBOX(
    FILE ${NODE_MODULES_RESOURCE_ID}
    OUT_NOAUTO ${NODE_MODULES_OUT}
)

PYTHON(
    serp/node_modules/bin/unpack.py
    --input ${BUILD_DIR}/${NODE_MODULES_OUT}
    --dest ${BUILD_DIR}
    IN ${NODE_MODULES_OUT}
    OUT_NOAUTO ${NODE_MODULES_RESOURCE_FILES}
)

PYTHON(
    scripts/build.py
    --node-bin ${NODE}
    --protoc-bin ${PROTOC}
    --build-dir ${BUILD_DIR}
    --proto-paths ${ARCADIA_ROOT}:${ARCADIA_ROOT}/contrib/libs/protobuf/src
    --proto-targets ${ARCADIA_ROOT}/tasklet/tests/proto:${ARCADIA_ROOT}/tasklet/api
    --proto-relative-output proto
    --entry-point ${SOURCE_DIR}/tasklet.js
    --output-bundle tasklet.bundle.js
    OUT_NOAUTO tasklet.bundle.js
    TOOL ${NODE}
    TOOL ${PROTOC}
    IN ${NODE_MODULES_RESOURCE_FILES}
    package.json
    tasklet.js
)

END()
