from metrics_tools import FilterType
from metrics_tools import WizardFilter

OTHER = "OTHER"


WIZARD_FILTERS = {
    "ALL": WizardFilter(),
    "ALL_ADDV": WizardFilter(component_type="ADDV"),
    "ALL_ORGANIC": WizardFilter(component_type="SEARCH_RESULT"),
    "ALL_WIZARDS": WizardFilter(only_with_wizard_types=True),
    "IMAGE": WizardFilter(baobab={"images"}, wizard_types={"WIZARD_IMAGE"}, filter_type=FilterType.ANY),
    "ENTITY_SEARCH": {
        "ENTITY_SEARCH_UPPER": WizardFilter(wizard_types={"WIZARD_ENTITY_SEARCH_UPPER"}, filter_type=FilterType.ANY),
        OTHER: WizardFilter(baobab={"entity_search"}, wizard_types={"WIZARD_KNOWLEDGE_GRAPH", "WIZARD_ENTITY_SEARCH_UPPER"}, filter_type=FilterType.ANY),
    },
    "VIDEO": {
        "SHORT_VIDEO": WizardFilter(baobab={"videoshort"}, filter_type=FilterType.ANY),
        OTHER: WizardFilter(baobab={"videowiz", "video-unisearch"}, wizard_types={"WIZARD_VIDEO"}, filter_type=FilterType.ANY),
    },
    "ALL_FACTS": {
        "SUGGEST_FACT": WizardFilter(baobab={"suggest_fact"}, wizard_types={"WIZARD_SUGGEST_FACT"}, filter_type=FilterType.ANY),
        "MULTIPLE_FACTS": WizardFilter(baobab={"multiple_facts"}, filter_type=FilterType.ANY),
        "FACT_INSTRUCTION": WizardFilter(baobab={"fact_instruction"}, filter_type=FilterType.ANY),
        "ENTITY_FACT": WizardFilter(baobab={"entity-fact"}, wizard_types={"WIZARD_ENTITY_FACT"}, filter_type=FilterType.ANY),
        "DICT_FACT": WizardFilter(baobab={"dict_fact"}, filter_type=FilterType.ANY),
        "TABLE_FACT": WizardFilter(baobab={"table_fact"}, filter_type=FilterType.ANY),
        "RICH_FACT": WizardFilter(baobab={"rich_fact"}, filter_type=FilterType.ANY),
        "CALCULATOR": WizardFilter(baobab={"calculator"}, filter_type=FilterType.ANY),
        "COLORS": WizardFilter(baobab={"colors"}, wizard_types={"WIZARD_COLORS"}, filter_type=FilterType.ANY),
        "DISTANCE_FACT": WizardFilter(baobab={"distance_fact"}, filter_type=FilterType.ANY),
        "IMAGE_FACT": WizardFilter(baobab={"image_fact"}, filter_type=FilterType.ANY),
        "LYRICS": WizardFilter(baobab={"lyrics"}, filter_type=FilterType.ANY),
        "POETRY_LOVER": WizardFilter(baobab={"poetry_lover"}, filter_type=FilterType.ANY),
        "TIME": WizardFilter(baobab={"time"}, filter_type=FilterType.ANY),
        "CONVERTER": WizardFilter(baobab={"units_converter", "currency_converter"}, wizard_types={"WIZARD_CONVERTER"}, filter_type=FilterType.ANY),
        "MATH": WizardFilter(baobab={"math"}, filter_type=FilterType.ANY),
    },
    "RELATED_DISCOVERY": WizardFilter(baobab={"related_discovery"}, wizard_types={"METRICS_RELATED_QUERIES"}, filter_type=FilterType.ANY),
    "YABS_PROXY": WizardFilter(baobab={"yabs_proxy"}, wizard_types={"WIZARD_YABS_PROXY"}, filter_type=FilterType.ANY),
    "MARKET_CONSTR": WizardFilter(baobab={"market_constr"}, wizard_types={"WIZARD_MARKET"}, filter_type=FilterType.ANY),
    "GEO": {
        "GEO_COMPANY": WizardFilter(baobab={"companies"}, baobab_subtype={"company"}, filter_type=FilterType.ANY),
        "GEO_MAP": WizardFilter(baobab={"companies"}, baobab_subtype={"map"}, filter_type=FilterType.ANY),
        "GEO_TRAVEL_COMPANY": WizardFilter(baobab={"companies"}, baobab_subtype={"travel_company"}, filter_type=FilterType.ANY),
        "GEO_TRAVEL_MAP": WizardFilter(baobab={"companies"}, baobab_subtype={"travel_map"}, filter_type=FilterType.ANY),
        OTHER: WizardFilter(wizard_types={"WIZARD_ADRESA", "WIZARD_ORGMN", "WIZARD_ORGANIZATION_CARD"}, filter_type=FilterType.ANY),
    },
    "ARTICLE": WizardFilter(baobab={"article"}, filter_type=FilterType.ANY),
    "MUSIC": WizardFilter(baobab={"musicplayer"}, wizard_types={"WIZARD_MUSIC"}, filter_type=FilterType.ANY),
    "DRUGS": WizardFilter(baobab={"drugs"}, filter_type=FilterType.ANY),
    "TRANSLATE": WizardFilter(baobab={"translate"}, wizard_types={"WIZARD_TRANSLATE"}, filter_type=FilterType.ANY),
    "ALL_HEALTH": {
        "HEALTH": WizardFilter(baobab={"health"}, wizard_types={"WIZARD_HEALTH_ARTICLE"}, filter_type=FilterType.ANY),
        "HEALTH_ENCYCLOPEDIA": WizardFilter(baobab={"health_encyclopedia"}, wizard_types={"WIZARD_HEALTH_ENCYCLOPEDIA"}, filter_type=FilterType.ANY),
    },
    "WEATHER": WizardFilter(baobab={"weather"}, wizard_types={"WIZARD_WEATHER"}, filter_type=FilterType.ANY),
    "MAPS": WizardFilter(baobab={"maps"}, wizard_types={"WIZARD_MAPS"}, filter_type=FilterType.ANY),
    "SPECIAL_EVENT": WizardFilter(baobab={"special/event"}, wizard_types={"WIZARD_SPORT_SPECIAL"}, filter_type=FilterType.ANY),
    "TRANSPORT": WizardFilter(baobab={"geo_common_wizard"}, wizard_types={"WIZARD_TRANSPORT"}, filter_type=FilterType.ANY),
    "Q": WizardFilter(baobab={"q"}, filter_type=FilterType.ANY),
    "ALL_AUTO": WizardFilter(baobab={"auto_2", "autoparts/thumbs-text"}, wizard_types={"WIZARD_AUTO"}, filter_type=FilterType.ANY),
    "RASPISANIE": WizardFilter(baobab={"rasp"}, wizard_types={"WIZARD_RASPISANIE"}, filter_type=FilterType.ANY),
    "REALTY_GALLERY": WizardFilter(baobab={"realty/gallery"}, filter_type=FilterType.ANY),
    "TICKET": WizardFilter(baobab={"buy_tickets"}, wizard_types={"WIZARD_TICKET"}, filter_type=FilterType.ANY),
    "YDO": WizardFilter(baobab={"ydo"}, filter_type=FilterType.ANY),
    "GAMES_CATEGORY": WizardFilter(baobab={"games_category"}, wizard_types={"WIZARD_GAMES"}, filter_type=FilterType.ANY),
    "GAMES_ONE": WizardFilter(baobab={"games_one"}, filter_type=FilterType.ANY),
    "NEWS": WizardFilter(baobab={"news"}, wizard_types={"WIZARD_NEWS"}, filter_type=FilterType.ANY),
    "FASTRES": WizardFilter(baobab={"fastres"}, filter_type=FilterType.ANY),
    "STOCKS": WizardFilter(baobab={"stocks"}, wizard_types={"WIZARD_STOCKS"}, filter_type=FilterType.ANY),
    "ROUTE": WizardFilter(baobab={"route"}, wizard_types={"WIZARD_ROUTE"}, filter_type=FilterType.ANY),
    "VACANCIES": WizardFilter(baobab={"rabota"}, wizard_types={"WIZARD_VACANCIES"}, filter_type=FilterType.ANY),
    # "ENTITY_MOVIE": {
    #     "ENTITY_MOVIE_CINEMA": WizardFilter(baobab={"entity/movie"}, baobab_subtype={"cinema"}),
    #     "ENTITY_MOVIE_TRAILER": WizardFilter(baobab={"entity/movie"}, baobab_subtype={"trailer"}),
    # },
    "ALL_UNISEARCH": {
        "UNISEARCH_EDUCATION": WizardFilter(baobab={"unisearch/education"}),
        "UNISEARCH_MEDICINE": WizardFilter(baobab={"unisearch/medicine"}),
        "UNISEARCH_APPLICATIONS": WizardFilter(baobab={"unisearch/applications"}),
    },
    "ALL_COST_PLUS": {
        "COST_PLUS_AUTO": WizardFilter(baobab_features={"autoru/thumbs-price", "autoru/thumbs-text", "autoru/thumbs-gallery"}, filter_type=FilterType.ANY),
        "COST_PLUS_YDO": WizardFilter(baobab_features={"ydo"}, filter_type=FilterType.ANY),
        "COST_PLUS_JOB": WizardFilter(baobab_features={"mushroom"}, baobab_subtype={"vkus"}, filter_type=FilterType.ANY),
        "COST_PLUS_REALTY": WizardFilter(baobab_features={"realty/gallery", "realty/site-gallery"}, filter_type=FilterType.ANY),
    },
}
