import os

from build.plugins.lib.nots.package_manager import manager, constants


def create_node_modules_parser(subparsers):
    cmd = subparsers.add_parser("create-node-modules", help="create node_modules directory")
    cmd.add_argument("--build-root", required=True)
    cmd.add_argument("--bindir", required=True)
    cmd.add_argument("--curdir", required=True)
    cmd.add_argument("--nodejs-bin", required=True)
    cmd.add_argument("--pnpm-script", required=True)
    cmd.add_argument("--contribs", required=True)
    cmd.set_defaults(func=create_node_modules_func)


def create_node_modules_func(args):
    pm = manager(
        build_root=args.build_root,
        build_path=args.bindir,
        sources_path=args.curdir,
        nodejs_bin_path=args.nodejs_bin,
        script_path=args.pnpm_script,
        contribs_path=os.path.join(args.build_root, args.contribs),
    )

    pm.install()
    pm.create_node_modules_bundle(constants.NODE_MODULES_BUNDLE_FILENAME)
