# releaser
Утилита командной строки для сборки и выкладки приложений и библиотек.

## Установка:

1. Скачайте [ya tool](https://wiki.yandex-team.ru/yatool/)
2. Пропишите alias для `ya tool releaser`
3. При запуске, `ya tool` автоматически обновит релизер до последней версии

Для работы требуется oauth токен, он получается [автоматически](https://pg.at.yandex-team.ru/5490) по ssh ключу прописанному на стаффе, но если у вас это не работает, то необходимо прописать переменную `oauth_token` в `~/.release.hjson`.
Ее значением должен быть токен, связанный с пользователем, который имеет права на работу с указанным Qloud окружением.
[Получить токен](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=69bfc53a5e7144c281ccf88ca7e98598).

#### Пример файла
```(json)
oauth_token: AQAD-qJSJiQqBxX9VPVMkBBD1vdvfCvvBTdIi1E
```

Зайдите в корневую директорию проекта и запустите нужную команду `releaser <command>`.

Чтобы вывести help в консоли для команды, введите `releaser <command> --help`.

Узнать номер установленной версии releaser можно с помощью `releaser --version`.


## Использование
В `releaser` есть обычные два типа команд: обычные и воркфлоу.
Обычная команда делает одну простую задачу (например,
добавить новую запись в файл ченжлога или запушить собранный docker-образ в
registry) и принимает множество параметров для тонкой настройки.
Воркфлоу-команды предназначены для более высокоуровневых задач:
собрать библиотеку и залить ее в репозиторий, собрать новую версию сервиса и
задеплоить его. Эти команды устроен как последовательность вызовов обычных
команд. Воркфлоу-команды могут принимать и проксировать некоторые из параметров
в субкоманды, однако большинство из них удобнее указать в конфигурационном файле и
переопределять при вызове лишь необходимое (например, имя приложения в кулауде
и список его компонент логично положить в конфигурационный файл в репозитории,
а окружение, куда нужно деплоить в данный момент может быть удобно передавать
параметром утилиты, хотя значение по умолчанию удобно также положить в конфиг).


## Воркфлоу-команды
В любую воркфлоу-команду можно передать опцию `--dry-run`, чтобы
увидеть последовательность шагов, которые будут выполнены и эмуляцию работы
этих шагов.
Также воркфлоу-команды принимают параметр `--skip` — в него можно передать
последовательность шагов, которые нужно пропустить через запятую.
Если во время выполнения какого-то шага произошла ошибка, то релизер
пытается откатить предыдущие шаги, если для них существуют rollback-версии
команд (отключить это поведение можно опцией `--no-rollback`).

Опции `dry-run`, `skip` и `no-rollback` можно установить в конфигурационных
файлах как для всех, так и для конкретных воркфлоу команд. Синтаксис
`имя_команды.имя_опции: значение` (например, `release.skip: vcs_tag`).

`releaser release`
  Команда, запускающая команды в указанном порядке:
  ```
  releaser changelog
  releaser build
  releaser push
  releaser deploy
  ```
  Эта команда выполняет полную последовательность действий для выкладки сервиса в Qloud.

  Все опции соответствуют одноименным опциям вышеперечисленных команд.

  * `--remote, -r` – название удаленного репозитория по умолчанию – `origin`,
    с помощью этой опции его можно переопределить.
  * `--version, -v` – этой опцией можно явно указать название новой версии.
    По умолчанию releaser формирует название новой версии путем
    инкремента последнего числа в предыдущей версии. Эта версия послужит
    тэгом образа, который впоследствии будет собран, запушен в Registry
    и раздеплоен в Qloud.
  * `--non-interactive` – обновить changelog без открытия редактора (
    подходит для скриптов на buildfarm)
  * `--image, -i` – имя Docker образа. Опцию можно задать двумя способами:
    * Как суффикс `<image>` в полном имени образа `registry.yandex.net/<project>/<image>`.
    Например, если проект равен `tools`, то для получения полного имени образа
    `registry.yandex.net/tools/wiki-back` надо указать `wiki-back` в качестве данной опции.
    * Как полное имя Docker образа, например `registry.yandex.net/tools/wiki-back`

    Если не указать данную опцию, то по умолчанию она будет равна имени текущей директории
    и восприниматься как суффикс в полном имени образа.
  * `--pull-base-image` – в ходе сборки Docker образа подтянуть свежую версию базового.
  * `--pull-vcs` – подтянуть свежий код из репозитория перед выпуском версии.
  * `--buildfile` – имя файла с конфигом для `ya package --docker`
  * `--dockerfile, -f` – имя Dockerfile, по умолчанию `Dockerfile`.
  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--applications, -a` – comma-separated список названий Qloud приложений.
  * `--environment, -e` – название Qloud окружения.
  * `--target-state, -t` - целевое состояние Qloud окружения. Если в окружении включена политика
  [Committer cannot deploy](https://wiki.yandex-team.ru/qloud/doc/environment/#policies), то можно
  деплоить окружение, указывая состояние `PREPARED`.
  * `--components, -c` – comma-separated список Qloud компонент, которые
    нужно задеплоить.
  * `--dump` – если опция указана, то окружение будет задеплоено из дампа,
    лежащего в указанном файле, с заменой полей `repository`, `hash` и `objectId`.
  * `--deploy-comment-format, -dcf` - формат комментария деплоя в Qloud.
    Подробнее об опции в разделе _Комментарий деплоя в Qloud_.
  * `--version-build-arg` – добавляет `--build-arg APP_VERSION=<version>`
    при сборке образа. При добавлении этой опции вы обязаны использовать
    аргумент `APP_VERSION` в своем `Dockerfile`, иначе `docker build`
    вернет ошибку.
  * `--var` - позволяет задать одну или несколько переменных окружения.
    Используется так: `--var DB_HOST=some-db.in.pgaass`.
    Эту опцию можно указывать несколько раз.

  __Пример__: пусть вам нужно выложить в тестинг новую версию образа
  `registry.yandex.net/tools/wiki-back`, в приложение `wiki-back-intranet`,
  компоненты `backend` и `celery`. Версию явно передавать не будем. Пусть
  версия до выкладки была равна `8.1-3`. Образ надо собирать из файла
  `project.Dockerfile`.

  Команда вызывается так:

  ```
  releaser release -i wiki-back -f project.Dockerfile -a wiki-back-intranet -e testing -c backend,celery
  ```

  Эта команда вызывает следующую последовательность действий:

  ```
  releaser changelog
  releaser vcs_commit
  releaser vcs_tag
  ```

  В changelog добавится секция изменений с версией `8.1-4`.

  Дальше будут выполнены следующие команды (команды `releaser build` и
  `releaser push` "развернуты" до оригинальных команд `docker`)

  ```
  docker build -f project.Dockerfile -t registry.yandex.net/tools/wiki-back:8.1-4 .
  docker push registry.yandex.net/tools/wiki-back:8.1-4
  git push && git push --tags
  releaser deploy -i wiki-back -v 8.1-4 -a wiki-back-intranet -e testing -c backend,celery
  ```

----


`releaser release_changelog`
  Команда, запускающая команды в указанном порядке:
  ```
  releaser changelog
  releaser vcs_commit
  releaser vcs_tag
  releaser vcs_push
  ```
  Эта команда только обновляет ченжлог, коммитит и пушит в систему контроля
  версий. Дальше сборка может происходить на CI.


  * `--remote, -r` – название удаленного репозитория по умолчанию – `origin`,
    с помощью этой опции его можно переопределить.
  * `--version, -v` – этой опцией можно явно указать название новой версии.
    По умолчанию releaser формирует название новой версии путем
    инкремента последнего числа в предыдущей версии. Эта версия послужит
    тэгом образа, который впоследствии будет собран, запушен в Registry
    и раздеплоен в Qloud.
  * `--non-interactive` – обновить changelog без открытия редактора (
    подходит для скриптов на buildfarm)
  * `--pull-vcs` – подтянуть свежий код из репозитория перед обновлением журнала изменений.

----

## releaser stand
`releaser stand`
  Команда, выкладывающая стенд. Во многом работает аналогично команде
  `releaser release`, за исключением следующих моментов:

  * Не вызывает `releaser changelog`
  * Вместо опций `--version` и `--environment` используется единая
    опция `--stand` – имя стенда. Тэг образа и название окружения
    совпадают с именем стенда. В качестве стенда обычно используется
    логин автора стенда, за которым следует цифра-индекс стенда.

  Список опций:

  * `--stand, -s` – имя стенда
  * `--image, -i` – имя Docker образа. Опцию можно задать двумя способами:
    * Как суффикс `<image>` в полном имени образа `registry.yandex.net/<project>/<image>`.
    Например, если проект равен `tools`, то для получения полного имени образа
    `registry.yandex.net/tools/wiki-back` надо указать `wiki-back` в качестве данной опции.
    * Как полное имя Docker образа, например `registry.yandex.net/tools/wiki-back`

    Если не указать данную опцию, то по умолчанию она будет равна имени текущей директории
    и восприниматься как суффикс в полном имени образа.
  * `--pull-base-image` – в ходе сборки Docker образа подтянуть свежую версию базового.
  * `--buildfile` – имя файла с конфигом для `ya package --docker`
  * `--dockerfile, -f` – имя Dockerfile, по умолчанию `Dockerfile`.
  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--applications, -a` – comma-separated список названий Qloud приложений.
  * `--components, -c` – comma-separated список Qloud компонент, которые
    нужно задеплоить.
  * `--dump` – если опция указана, то окружение будет задеплоено из дампа,
    лежащего в указанном файле, с заменой полей `repository`, `hash` и `objectId`.
  * Группа опций, пробрасывающая ключ тикета, по которому ведутся работы на стенде,
    в комментарий деплоя в Qloud, для последующей обработки деплой-хуком.
    Ключ тикета берется по первой опции, с помощью которой
    его удалось извлечь, опции обрабатываются в порядке списка ниже:
    * `--ticket` – явное указание ключа тикета
    * `--get-ticket-from-stand-name` – попытаться взять ключ тикета из имени стенда
    * `--get-ticket-from-last-commit-message` – попытаться взять ключ тикета из message последнего коммита (это поведение по-умолчанию, чтобы отключить его, надо указать опцию `--no-get-ticket-from-last-commit-message`)
    * `--get-ticket-from-current-branch-name` – попытаться взять ключ тикета из имени текущей ветки
  * `--domain-tpl` — шаблон домена стенда, в который будет подставлена
    переменные `standname` и `application`
    (например, `review-{standname}.unstable.tools.yandex-team.ru`
    или `{application}-{standname}.unstable.tools.yandex-team.ru`)
     По умолчанию домен добавлен не будет
  * `--deploy-hook` — деплой хук для окружения домена (например, https://qooker.yandex-team.ru/hook).
     По умолчанию деплой хук добавлен не будет.
  * `--var` - позволяет задать одну или несколько переменных окружения.
    Используется так: `--var DB_HOST=some-db.in.pgaass`.
    Эту опцию можно указывать несколько раз.

  __Пример__: пусть вам нужно выложить стенд с именем `o-gulyaev4` образа
  `registry.yandex.net/tools/wiki-stand-back`, в приложение `wiki-stand-back-intranet`,
  компоненты `backend` и `celery`.

  Команда вызывается так:

  ```
  releaser stand -s o-gulyaev4 -i wiki-stand-back -a wiki-stand-back-intranet -c backend,celery
  ```

  Эта команда вызывает следующую последовательность действий:

  ```
  docker build -t registry.yandex.net/tools/wiki-stand-back:o-gulyaev4 .
  docker push registry.yandex.net/tools/wiki-stand-back:o-gulyaev4
  releaser deploy -i wiki-stand-back -v o-gulyaev4 -a wiki-stand-back-intranet -e o-gulyaev4 -c backend,celery
  ```

----

`releaser stand-ticket`
  Выводит в stdout id тикета, точно такого же, который был бы использован командой
  `stand`, вызванной с такими же опциями.

## Обычные команды
Все команды принимают опцию `--dry-run`, которая включает режим эмуляции
выполнения, реальных действий на запись в этом режиме не происходит.

`releaser changelog`
  Эта команда соберет коммиты с предыдущей версии и добавит новую запись в
  changelog.md, а затем откроет редактор, чтобы можно было внести правки.
  Для сохранения изменений нужно просто закрыть редактор с сохранением файла.
  Если закрыть без сохранения — ченжлог не будет обновлен и команда прекратит
  выполнение.

  * `--non-interactive` – обновить changelog без открытия редактора (
    подходит для скриптов на buildfarm)
  * `--version, -v` – этой опцией можно явно указать название новой версии.
    По умолчанию releaser формирует название новой версии путем
    инкремента последнего числа в предыдущей версии.
  * `--pull-vcs` – подтянуть свежий код из репозитория перед обновлением журнала изменений.

  __Пример__: предположим, что последняя версия в changelog.md 0.4.0

  ```
  releaser changelog
  # новая версия 0.4.1

  releaser changelog -v 0.5.0
  # новая версия 0.5.0
  ```

----

`releaser version`
  Эта команда ищет и обновляет версию в файлах, пока поддерживается
  форматы `setup.py`, `ya.make`, `package.json` и указание своей регулярки в конфиге.

  * `--version, -v` – этой опцией можно явно указать название новой версии.
    По умолчанию — последняя версия из ченжлога.
  * `--version-file-path` – явно указание пути до файла, который нужно обновлять,
    можно использовать несколько раз.

  В конфиге, помимо `version_file_path`, можно указать параметр `version_files`,
  куда кладется либо массив путей до файлов, либо словарь, где ключ — путь до файла,
  а значение — регулярка для поиска версии, в которой одна группа, она будет заменена на версию.

----

`releaser vcs_commit`
  Закоммитить ченжлог со стандартным коммит-сообщением (releasing version X.X.X).

  * `--version, -v` – этой опцией можно явно указать название новой версии для
    коммит-сообщения.


----

`releaser vcs_tag`
  Поставить тег в системе контроля версий.

  * `--version, -v` – этой опцией можно явно указать название новой версии для
    тега.

----

`releaser vcs_push`
  Запушить коммиты и теги в удаленный vcs-репозиторий.

  * `--remote, -r` – название удаленного репозитория по умолчанию – `origin`.


----

`releaser vcs_pull`
  Подтянуть свежий код из репозитория.


----

`releaser build`
  Команда для сборки Docker образа.
  * `--image, -i` – имя Docker образа. Опцию можно задать двумя способами:
    * Как суффикс `<image>` в полном имени образа `registry.yandex.net/<project>/<image>`.
    Например, если проект равен `tools`, то для получения полного имени образа
    `registry.yandex.net/tools/wiki-back` надо указать `wiki-back` в качестве данной опции.
    * Как полное имя Docker образа, например `registry.yandex.net/tools/wiki-back`

    Если не указать данную опцию, то по умолчанию она будет равна имени текущей директории
    и восприниматься как суффикс в полном имени образа.
  * `--pull-base-image` – в ходе сборки Docker образа подтянуть свежую версию базового.
  * `--version, -v` – версия, он же тег, собираемого Docker образа.
  * `--buildfile` – имя файла с конфигом, чтобы собирать через `ya package --docker`
  * `--sandbox` - собрать образ через sandbox задачу `YA_PACKAGE`, используя `ya tool sandboxctl`
    * В конфиг можно добавить словарь `sandbox_config`, для добавления разных параметров sandbox таски
    * На данный момент обязательными являются параметры `docker_user` и `docker_token_vault_name`
    * Для запуска от имени группы в `sandbox_config` надо добавить `owner: name` e.g. `owner: TOOLS`
  * `--dockerfile, -f` – имя Dockerfile, по умолчанию `Dockerfile`.
  * `--version-build-arg` – добавляет `--build-arg APP_VERSION=<version>`
    при сборке образа. При добавлении этой опции вы обязаны использовать
    аргумент `APP_VERSION` в своем `Dockerfile`, иначе `docker build`
    вернет ошибку.

----

`releaser push`
  Команда для пуша Docker образа в Registry.
  * `--image, -i` – имя Docker образа. Опцию можно задать двумя способами:
    * Как суффикс `<image>` в полном имени образа `registry.yandex.net/<project>/<image>`.
    Например, если проект равен `tools`, то для получения полного имени образа
    `registry.yandex.net/tools/wiki-back` надо указать `wiki-back` в качестве данной опции.
    * Как полное имя Docker образа, например `registry.yandex.net/tools/wiki-back`

    Если не указать данную опцию, то по умолчанию она будет равна имени текущей директории
    и восприниматься как суффикс в полном имени образа.
  * `--version, -v` – версия, он же тег, Docker образа, который надо запушить.

----

`releaser deploy`
  Команда для деплоя компонентов в указанном Qloud окружении.
  * `--image, -i` – имя Docker образа. Опцию можно задать двумя способами:
    * Как суффикс `<image>` в полном имени образа `registry.yandex.net/<project>/<image>`.
    Например, если проект равен `tools`, то для получения полного имени образа
    `registry.yandex.net/tools/wiki-back` надо указать `wiki-back` в качестве данной опции.
    * Как полное имя Docker образа, например `registry.yandex.net/tools/wiki-back`

    Если не указать данную опцию, то по умолчанию она будет равна имени текущей директории
    и восприниматься как суффикс в полном имени образа.
  * `--version, -v` – версия, он же тег, Docker образа, который нужно
    задеплоить. Помеченный этой версией образ предварительно должен
    быть запушен в registry. В качестве версии рекомендуется использовать новую
    версию, полученную после запуска `releaser changelog`.
  * `--pull-vcs` – подтянуть свежий код из репозитория перед выкладкой.
  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--applications, -a` – comma-separated список названий Qloud приложений.
  * `--environment, -e, --stage` – название Qloud окружения или stage для Y.Deploy.
  * `--target-state, -t` - целевое состояние Qloud окружения. Если в окружении включена политика
  [Committer cannot deploy](https://wiki.yandex-team.ru/qloud/doc/environment/#policies), то можно
  деплоить окружение, указывая состояние `PREPARED`.
  * `--components, -c, --deploy-units` – comma-separated список Qloud компонент, которые
    нужно задеплоить или deploy units из Y.Deploy.
  * `--box` - box для Y.Deploy, деплой в Y.Deploy буде осуществляться только если указана эта опция.
  * `--dump` – если опция указана, то окружение будет задеплоено из дампа,
    лежащего в указанном файле, с заменой полей `repository`, `hash` и `objectId`.
  * `--deploy-comment-format, -dcf` - формат комментария деплоя в Qloud.
    Подробнее об опции в разделе _Комментарий деплоя в Qloud_.
  * `--var` - позволяет задать одну или несколько переменных окружения.
    Используется так: `--var DB_HOST=some-db.in.pgaass`.
    Эту опцию можно указывать несколько раз.

  __Пример__: пусть вам нужно задеплоить образ `registry.yandex.net/tools/wiki-back:4.3`
  в приложение `wiki-back-intranet`, окружение `testing`, компоненты `backend` и `celery`.
  В таком случае команду можно вызвать так:

  ```
  releaser deploy -i wiki-back -v 4.3 -a wiki-back-intranet -e testing -c backend,celery
  ```

---

`releaser add_domain`
  Добавляет домен в указанное окружение.

  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения.
  * `--domain, -d` – домен.
  * `--domain-type` – балансер в qloud (например, `tools-int-test`) или namespace в deploy.
  * `--deploy` - признак для использования деплоя

В конфигах балансеров деплоя должна быть включена поддержка [доменов](https://wiki.yandex-team.ru/cplb/awacs/top-level-easy-mode/#includedomains). Команда опирается на наличие домена с названием `default-domain`, в котором выбраны нужные upstream, он будет шаблоном для нового домена. Каждый upstream будет скопирован (и использован в новом домене) с подменой бекендов (пока поддерживается только [flat_scheme](https://wiki.yandex-team.ru/cplb/awacs/upstream-easy-mode/#dictflatscheme)) на новый бекенд, где соберутся все деплой юниты,
упомянутые в исходных бекендах, у которых подменится стейдж. Сертификат тоже будет скопирован, для стабильной работы он должен покрывать все новые домены. И не забудьте поправить dns запись для новых доменов, обычно это wildcard CNAME запись на домен балансера. [Пример](https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/staff-api.test.yandex-team.ru/domains/list/default-domain/show/).

----

`releaser add_deploy_hook`
  Добавляет деплой хук в указанное окружение.

  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения.
  * `--deploy-hook` – урл деплой-хука, например https://qooker.yandex-team.ru/hook

----

`releaser env_delete`
  Удаление окружения(-ий).

  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения. Можно использовать wildcard –
  например, `-e '*'` приведет к удалению всех окружений в приложении, а `-e 'stand*'` –
  окружений, начинающихся на `stand`.
  * `--non-interactive` – удаление нескольких окружений без подтверждения.

----

`releaser env_dump`
  Берет дамп окружения и кладет его в файл в формате hjson.
  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения.
  * `--dump` – путь до файла.

----

`releaser status`
  Отображает статус всех инстансов в текущей версии окружения.
  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения.

----

`releaser ssh`
  Команда выбирает случайный инстанс заданного компонента и заходит в него по SSH.

  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения.
  * `--component, -c` – название Qloud компоненты.

----

`releaser pssh`
  Команда для запуска команды на всех хостах используя
  [parallel-ssh](https://github.com/labatrockwell/parallel-ssh).
  Требует установленного parallel-ssh или аналога, принимающего список хостов в
  виде `-H host1 -H host2 ...`.

  * `--qloudinst, -q` – инстанс Qloud
    (`int` для https://qloud.yandex-team.ru, `ext` для https://qloud-ext.yandex-team.ru).
    По умолчанию – `ext`.
  * `--project, -p` – имя проекта в Qloud (например `junk`, `tools`). По умолчанию – `tools`.
  * `--application, -a` – название Qloud приложения.
  * `--environment, -e` – название Qloud окружения.
  * `--component, -c` – название Qloud компоненты.
  * `--pssh-cmd` – имя команды для запуска. По умолчанию – `pssh`. Пример: `pscp`, `pslurp`.

  Примеры:

      releaser pssh uptime

      releaser pssh --pssh-cmd=pslurp /var/log/syslog ./

----

`releaser convert_changelog`
  Преобразует старый debian-ченжлог в новый формат.
  Эта опция только создаёт новый файл, без коммита и пуша. Перед использованием
  ознакомьтесь с разделом _Подробнее про convert_.

---

### Выгрузка логов в YT

`releaser add-logs`
  Команда добавляет настроенный push-client во всe балансеры указанного awacs namespace.

  * `--domain-type` – namespace в awacs
  * `--tvm-client-id` – tvm приложения, от лица которого логи будут пушится в logbroker, у вас должен быть доступ до секрета tvm.secret.\<client_id> в [секретнице](https://yav.yandex-team.ru/)
  * `--logbroker-topic` – топик в logbroker, в который можно писать от лица вышеуказанного tvm приложения

  Перед запуском команды поставьте на [паузу](https://jing.yandex-team.ru/files/smosker/2020-10-20_12-40-00.png) обновления конфигов балансеров
  https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/<namespace>/show/

  После запуска можете проверить дифф перейдя по ссылкам из output команды, после чего
  по очереди снимайте балансеры с паузы - новый конфиг начнет применяться автоматически.

  Немного рекомендаций:
  - Проверяйте diff, который сгенерировала команда
  - Для клиента установлен лимит в 0.3 cpu на инстанс, не надо добавлять его на балансеры, которым выделено меньше 1 cpu
  - Катите балансеры по очереди, тем более в проде :)
  - Резкое повышение cpu wait при первой выкатке это, кажется, ок, выгружаются логи, которые уже лежали на инстансе


## Конфигурация
Все опции команд можно прописать в конфиг файле, в формате `<полное имя опции>: <значение>`.
Конфиг описывается в формате [HJSON](http://hjson.org/) (надмножество [JSON](http://json.org/)).
Опции ищутся по очереди в следующих местах
  * `/etc/release.hjson` (`$RELEASER_GLOBAL_CONFIG`)
  * `~/.release.hjson` (`$RELEASER_USER_CONFIG`)
  * `./.release.hjson` (`$RELEASER_PROJECT_CONFIG`)
  * `$RELEASER_LOCAL_CONFIG`
  * `$RELEASER_<var_name>`
Путь до любого файла можно переопределить, либо можно переопределить
любую опцию переменной окружения. Имена опций в конфигах совпадают с именами
в параметрах команд (минусы заменяются на подчеркивания).

[Пример проектного конфига.](example.project.release.hjson)
[Пример пользовательского конфига.](example.user.release.hjson)

Для проверки конфигурации можно использовать команду `releaser config`.

## Как работает команда releaser changelog
При вызове `releaser changelog` утилита обновляет changelog.md
с помощью библиотеки [gitchronicler](https://github.yandex-team.ru/tools/gitchronicler).

Библиотека gitchronicler обновляет changelog, используя output
команды `git log` со специальным форматом,
извлекая все коммиты с момента последней версии с помощью
интервала `last_version_tag..HEAD`, где `last_version_tag` –
git тэг последней версии, совпадающий с верхней строкой в changelog.

## Подробнее про convert
Если вы создали новый changelog, сконвертировав его из старого `debian/changelog`
с помощью команды convert, то убедитесь в том, что git тэг последней версии совпадает
с верхней строкой нового changelog.

В общем случае это может быть не так – например, если раньше скрипт выпуска
новой версии писал новую версию в `debian/changelog` как `0.8.3`,
а тэг при этом называл по-другому: `debian/0.8.3`, `v0.8.3` и т.д.

Поэтому, если тэг последней версии и верхняя строка нового changelog не совпадают,
то исправьте верхнюю строку changelog.

Если этого не сделать, то последующие запуски `releaser` не будут работать,
поскольку `git log [last_version_tag..HEAD]` будет возвращать пустой список коммитов
(см. раздел _Что происходит при запуске release_).

## Комментарий деплоя в Qloud

Опция `--deploy-comment-format, -dcf` позволяет указать формат комментария
деплоя в Qloud. По умолчанию формат такой:

```
Releasing version {version}, changelog:\n{changelog}
```

где `{version}` - версия деплоящегося приложения, `{changelog}` - соответствующие
версии изменения из `changelog.md`.

Можно указать свой формат комментария, в нем можно также использовать
параметры `{version}` и `{changelog}`.

Чтобы комментария при деплое не было, укажите:

```
-dfc no
```
## Жизнь в Аркадии
Если вы переехали в Аркадию и собираетесь через аркадийную сборку - вам нужно использовать дополнительно аргумент `--buildfile`.
Если вы живете в аркадии без аркадийной сборке - используйте `releaser` так же как и раньше.

## Релиз новой версии

- выкатить новую версию ya tool releaser release_changelog
- скопировать таску https://sandbox.yandex-team.ru/task/785075388/view
- взять номер актуальной ревизии (например, из истории в папке проекта, вида r123455) и записать его в параметр Svn url for arcadia
- запустить таску
- дождаться пока отработает, скопировать номер новой таски сюда https://a.yandex-team.ru/arc/trunk/arcadia/build/ya.conf.json?rev=7482022#L5706
- после этого на следующий день подтянется в ya tool
