unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleServer, ExcelXP, AF_Proc, AF_Types, WinInet,
  Buttons, Grids;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox3: TComboBox;
    Label3: TLabel;
    XLApp: TExcelApplication;
    Button2: TButton;
    Button3: TButton;
    StringGrid1: TStringGrid;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    CheckBox1: TCheckBox;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Button15: TButton;
    Button16: TButton;
    Button17: TButton;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  stc,mlog: AF_Types.TStrings;
  workdir:string;

const
  yserver:string='https://rasp.yandex.ru';
  yserverv2:string='https://export.rasp.yandex.net';
  yserverv2_tst:string='https://testing.export.rasp.yandex.net';

implementation

{$R *.dfm}

procedure ParseCSVStrEx(ts:AF_Types.PStrings; s:widestring; c:char);
 var n:integer;
begin
  ts.clear;
  while pos(c,s)>0 do begin
    n:=pos(c,s);
    if n=1 then begin
      ts.add('');
      s:=copy(s,2,length(s)-1);
    end
     else begin
       ts.add(trim(copy(s,1,n-1)));
       s:=copy(s,n+1,length(s)-n);
     end;
  end;
   s:=trim(s);
   if length(s)>0 then ts.add(s);
end;

procedure LoadDirection;
  var f,u:AF_Types.TSTrings;
  var i:integer;
begin
  f.create; u.create;
  f.loadfromfile(workdir+form1.combobox1.items[form1.combobox1.itemindex]+'.dir');
  form1.combobox2.ItemIndex:=-1;
  form1.ComboBox2.Items.Clear;
  form1.button1.enabled:=false;
  stc.clear;
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),';');
      if validstr(u.getstring(1)) then begin
        form1.ComboBox2.Items.Add(u.getstring(2));
        stc.add(u.getstring(1));
      end;
    end;
    form1.combobox2.itemindex:=0;
    form1.button1.enabled:=true;
  end;
  f.free; u.free;
end;

Procedure GetInetFile (const fileURL, FileName: String);
const BufferSize = 1024;
var
  hSession, hURL: HInternet;
  Buffer: array[1..BufferSize] of Byte;
  BufferLen: DWORD;
  f: File;
  sAppName: String;
begin
  sAppName := ExtractFileName(Application.ExeName);
  hSession :=InternetOpen(PChar(sAppName), INTERNET_OPEN_TYPE_PRECONFIG, nil, nil, 0);
  try
    hURL := InternetOpenURL(hSession, PChar(fileURL), nil, 0, 0, 0);
    try
      AssignFile(f, FileName);
      Rewrite(f,1);
      {$I-}
      repeat
      try
        bufferlen:=0;
        InternetReadFile(hURL, @Buffer, SizeOf(Buffer), BufferLen);
      except
      end;
        if bufferlen>0 then begin
          try
           BlockWrite(f, Buffer, BufferLen)
          except
          end;
        end;
      until BufferLen = 0;
      {$I+}
      CloseFile(f);
    finally
      InternetCloseHandle(hURL)
    end
  finally
    InternetCloseHandle(hSession)
  end
end;

Procedure UTF8FileDecode(fn,fn1:string);
 var t,t1:textfile;
 var s:string;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     writeln(t1,Utf8ToAnsi(s));
   end;
  closefile(t1);
  closefile(t);
end;

Procedure XMLFile1(fn,fn1:string);
 var t,t1:textfile;
 var s,s1:string;
 var i:integer;
begin
  assignfile(t,fn);
  reset(t);
  assignfile(t1,fn1);
  rewrite(t1);
   while not eof(t) do begin
     readln(t,s);
     s1:='';
     if length(s)>0 then begin
       for i:=1 to length(s) do begin
         if s[i]='<' then s1:=s1+#13#10+s[i]
                     else s1:=s1+s[i];
       end;
     end;
     writeln(t1,s1);
   end;
  closefile(t1);
  closefile(t);
end;

function getParam(s1,s:string):string;
  var s2:string;
begin
  s:=trim(s);
  s2:='';
  if pos(s1+'="',s)>0 then begin
    s2:=copy(s,pos(s1+'="',s)+2+length(s1),length(s));
     if pos('"',s2)>0 then s2:=copy(s2,1,pos('"',s2)-1);
  end;
  result:=trim(s2);
end;

function PrepFn(s:string):string;
begin
  while pos('.',s)>0 do s[pos('.',s)]:=' ';
  while pos(',',s)>0 do s[pos(',',s)]:=' ';
  while pos(':',s)>0 do s[pos(':',s)]:=' ';
  while pos('/',s)>0 do s[pos('/',s)]:=' ';
  while pos('\',s)>0 do s[pos('\',s)]:=' ';
  result:=s;
end;

function vauxhall_replace(s:string):string;
begin
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  s:=StrReplace(s,' ( )',' ');
  if s='  ' then s:='';
  result:=s;
end;

function prep_time(s:string):string;
begin
 if pos('-',s)>0 then s[pos('-',s)]:=':';
 result:=s;
end;

procedure rsort3(p:AF_Types.PStrings);
  var f:AF_Types.TStrings;
  var i,n:integer;
  var s:string;
begin
  f.create;
  if p.count>0 then begin
   for i:=1 to p.count do begin
     if length(p.getstring(i))>1 then begin
       s:=copy(trim(p.getstring(i)),1,2);
       n:=strtointe(s);
       if n>2 then f.add(p.getstring(i));
     end;
   end;
   for i:=1 to p.count do begin
     if length(p.getstring(i))>1 then begin
       s:=copy(trim(p.getstring(i)),1,2);
       n:=strtointe(s);
       if n<=2 then f.add(p.getstring(i));
     end;
   end;
  end;
  p.clear;
  if f.count>0 then begin
   for i:=1 to f.count do p.add(f.getstring(i));
  end;
  f.free;
end;

procedure ProcessFile_new;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2,strp1,stdpstr,kgraph:string;
  var expr,stdplus:boolean;
  var len1, len2, len3, t1, t2 : integer;
  var curHour: string;
  var arrStationName : string;
  var stringNumber: string;
begin
with form1 do begin
  mcount:=0;
  kgraph:='g22';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_'+kgraph+'_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;

    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex];
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;

   // worksheet.columns.Item[3].ColumnWidth := 128;
    worksheet.Columns.Item[1, EmptyParam ].ColumnWidth := 20;
    worksheet.Columns.Item[2, EmptyParam ].ColumnWidth := 13.71;
    worksheet.Columns.Item[3, EmptyParam ].ColumnWidth := 70.57;

       //    
{       worksheet.cells.item[1,3].NumberFormat:='@';
       worksheet.cells.item[1,3]:=' 27  2015 .';
       worksheet.cells.item[1,3].Font.Size:=18;
       worksheet.cells.item[1,3].Font.Color:=clRed; }

    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_'+kgraph+'_',s)>0 then begin
      if pos('update="update"',s)<=0 then begin  //     
//      if true then begin
        if i<f.count then strp1:=f.getstring(i+1)
                     else strp1:='';
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos(' departure=',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          if pos('firmex',strp1)>0 then s1:=getParam('number',s)+' '
                                   else s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          s1 := StringReplace(s1,'  7', '', [rfReplaceAll, rfIgnoreCase] );
          if pos('  ',s1)>0 then s1:=copy(s1,1,pos('  ',s1)-1);
  {!!! }  //      if pos('  8',s1)>0 then s1:=copy(s1,1,pos('  8',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          s1 := StringReplace(s1,'  7', '', [rfReplaceAll, rfIgnoreCase] );
  {!!!} //       if pos('  8',s1)>0 then s1:=copy(s1,1,pos('  8',s1)-1);
          stdpstr:='';
          if pos('stdplus',strp1)>0 then stdpstr:='s';
          if pos('vag5',strp1)>0 then stdpstr:='s';
          if pos('vag11s',strp1)>0 then stdpstr:='s';
          if pos('std5sk',strp1)>0 then stdpstr:='s';
          if pos('spstdn',strp1)>0 then stdpstr:='s';
          if pos('firmex',strp1)>0 then stdpstr:='f';
          if pos('mcd1',strp1)>0 then stdpstr:='m';
          if pos('mcd2',strp1)>0 then stdpstr:='m';

          if pos('aerstd',strp1)>0 then stdpstr:='a' ;
          if pos('rex',strp1)>0 then stdpstr:='r';

        //  if stdpstr =  ''   then
        //      stdpstr :=  strp1 ;

          s2:=s2+#9+stdpstr;
 //         if pos('  ',s1)<=0 then begin
          t1 :=   pos('  ',s1);
          t2 :=  pos(' 7',s1);
          // if (pos('  ',s1)<=0) or (pos('  7 ',s1)>0) then begin
          if (t1 <=0) or ( t2 >0) then begin

           if length(s1)>0 then begin
             if not (s1[1] in ['0'..'9']) then begin
         //      if pos('',s1)<=0 then t.add(s2);  //  
             end;
           end;
          end;
             t.add(s2);   //  
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
     rsort3(@t);
     t.savetofile(workdir+inttostr(n)+'.txt');

     if (t.count>0) and not(dl.getstring(n) = '')  then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       curHour := '---';
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if (u.count>0) then begin
          expr:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;

          if  curHour <> Copy( prep_time(u.getstring(1)), 0,2) then
          begin
             curHour := Copy( prep_time(u.getstring(1)), 0,2);
             worksheet.cells.item[ms,1].NumberFormat:='@';
             worksheet.cells.item[ms,1] := curHour+':00';
             worksheet.cells.item[ms,1].Font.Bold := true ;
             worksheet.cells.item[ms,1].Font.Size  := 40  ;
   //          worksheet.cells.item[ms,1].Borders(8).Weight := 1;

             inc(ms);
          end;

          worksheet.cells.item[ms,1].NumberFormat:='@';
          worksheet.cells.item[ms,1]:=prep_time(u.getstring(1));  //
          worksheet.cells.item[ms,1].Font.Bold := true ;
          worksheet.cells.item[ms,1].VerticalAlignment := xlTop;

          worksheet.cells.item[ms,2].NumberFormat:='@';
          if (u.getstring(7) = 'o')  or  (u.getstring(7) = 'm') or  (u.getstring(7) = 'a')  then // or  (u.getstring(7) = 's')   then
                stringNumber:=u.getstring(7)+ chr(10) + u.getstring(2)   //
          else
                stringNumber:= u.getstring(2)+ chr(10)+u.getstring(7)  ; //

          worksheet.cells.item[ms,2]:=StringReplace(stringNumber, '/', ' / ', [ rfReplaceAll, rfIgnoreCase ] ) ;   //
          worksheet.cells.item[ms,2].VerticalAlignment := xlTop;
          worksheet.cells.item[ms,2].Font.Size  := 14  ;

          arrStationName :=   vauxhall_replace(u.getstring(4));
          arrStationName := StringReplace(arrStationName, '', '/', [ rfReplaceAll, rfIgnoreCase ] );

          worksheet.cells.item[ms,3].NumberFormat:='@';
          worksheet.cells.item[ms,3]:=arrStationName + chr(10) + u.getstring(5) + chr(10)  + vauxhall_replace(u.getstring(6)) ;  // 
          worksheet.cells.item[ms,3].VerticalAlignment := xlTop;

          len1 := Length(arrStationName);
          len2 := Length(u.getstring(5));
          len3 := Length(vauxhall_replace(u.getstring(6)));

          worksheet.cells.item[ms,3].Characters(1, len1  ).Font.Bold := true ;
          worksheet.cells.item[ms,3].Characters(len1+2+len2, len3+1  ).Font.Italic  := true ;
          if ansilowercase(u.getstring(5))=' ' then begin
               worksheet.cells.item[ms,3].Characters(len1+2, len2  ).Font.Color:=clRed;
          end;
          if ansilowercase(u.getstring(5))=' ' then begin
               worksheet.cells.item[ms,3].Characters(len1+2, len2  ).Font.Color:=clBlue;
          end;


//         worksheet.cells.item[ms,4].NumberFormat:='@';
//          worksheet.cells.item[ms,4]:=vauxhall_replace(u.getstring(3));  // 
//          worksheet.cells.item[ms,5].NumberFormat:='@';
//          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(4));  // 
//          worksheet.cells.item[ms,6].NumberFormat:='@';
//          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(6));  //
//          worksheet.cells.item[ms,7].NumberFormat:='@';
//          worksheet.cells.item[ms,7]:=u.getstring(2);  //
//          if u.getstring(7)='stdplus' then begin
//           if checkbox2.Checked then begin
//            worksheet.cells.item[ms,2].Font.Color:=clGreen;
//            worksheet.cells.item[ms,3].Font.Color:=clGreen;
//            worksheet.cells.item[ms,4].Font.Color:=clGreen;
//            worksheet.cells.item[ms,5].Font.Color:=clGreen;
//            worksheet.cells.item[ms,6].Font.Color:=clGreen;
//            worksheet.cells.item[ms,7].Font.Color:=clGreen;
//           end;
//          end;
//          if u.getstring(7)='firmex' then begin
//            worksheet.cells.item[ms,2].Font.Color:=rgb(255,153,0);
//            worksheet.cells.item[ms,3].Font.Color:=rgb(255,153,0);
//            worksheet.cells.item[ms,4].Font.Color:=rgb(255,153,0);
//            worksheet.cells.item[ms,5].Font.Color:=rgb(255,153,0);
//            worksheet.cells.item[ms,6].Font.Color:=rgb(255,153,0);
//            worksheet.cells.item[ms,7].Font.Color:=rgb(255,153,0);
 //         end
//           else begin
//            if expr then begin
//            worksheet.cells.item[ms,2].Font.Color:=clBlue;
//           worksheet.cells.item[ms,3].Font.Color:=clBlue;
//           worksheet.cells.item[ms,4].Font.Color:=clBlue;
//           worksheet.cells.item[ms,5].Font.Color:=clBlue;
//            worksheet.cells.item[ms,6].Font.Color:=clBlue;
//            worksheet.cells.item[ms,7].Font.Color:=clBlue;
//            end;
//           end;
//          if ansilowercase(u.getstring(5))=' ' then begin
//          //   
//            worksheet.cells.item[ms,3].Font.Color:=clRed;
//         end;
          inc(ms);
         end;
       end;
     //  worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
end;

procedure ProcessFile_old;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2,strp1,stdpstr,kgraph:string;
  var expr,stdplus:boolean;
  var t1, t2: integer;
begin
with form1 do begin
  mcount:=0;
  kgraph:='g22';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_'+kgraph+'_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex];
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;

       //    
{       worksheet.cells.item[1,3].NumberFormat:='@';
       worksheet.cells.item[1,3]:=' 27  2015 .';
       worksheet.cells.item[1,3].Font.Size:=18;
       worksheet.cells.item[1,3].Font.Color:=clRed; }

    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_'+kgraph+'_',s)>0 then begin
      if true then begin // pos('update="update"',s)<=0 then begin  //     
//      if true then begin
        if i<f.count then strp1:=f.getstring(i+1)
                     else strp1:='';
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos(' departure=',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          if pos('firmex',strp1)>0 then s1:=getParam('number',s)+' '
                                   else s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          s1 := StringReplace(s1,'  7', '', [rfReplaceAll, rfIgnoreCase] );
          if pos('  ',s1)>0 then s1:=copy(s1,1,pos('  ',s1)-1);
  {!!! }  //      if pos('  8',s1)>0 then s1:=copy(s1,1,pos('  8',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
  {!!!} //       if pos('  8',s1)>0 then s1:=copy(s1,1,pos('  8',s1)-1);
          stdpstr:='';
          if pos('stdplus',strp1)>0 then stdpstr:='stdplus';
          if pos('vag5',strp1)>0 then stdpstr:='stdplus';
          if pos('vag11s',strp1)>0 then stdpstr:='stdplus';
          if pos('std5sk',strp1)>0 then stdpstr:='stdplus';
          if pos('spstdn',strp1)>0 then stdpstr:='stdplus';
          if pos('firmex',strp1)>0 then stdpstr:='firmex';
          s2:=s2+#9+stdpstr;
          t1 :=   pos('  ',s1);
          t2 :=  pos(' 7',s1);
          // if (pos('  ',s1)<=0) or (pos('  7 ',s1)>0) then begin
          if (t1 <=0) or ( t2 >0) then begin

           if length(s1)>0 then begin
             if not (s1[1] in ['0'..'9']) then begin
              // if pos('',s1)<=0 then t.add(s2);  //  
             end;
           end;
          end;
             t.add(s2);   //  
        end;     
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
     rsort3(@t);
     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
          expr:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;
          worksheet.cells.item[ms,2].NumberFormat:='@';
          worksheet.cells.item[ms,2]:=prep_time(u.getstring(1));  //
          worksheet.cells.item[ms,3].NumberFormat:='@';
          worksheet.cells.item[ms,3]:=u.getstring(5);  //  -   
//          worksheet.cells.item[ms,3]:='29  30 ';  //  -   
          worksheet.cells.item[ms,4].NumberFormat:='@';
          worksheet.cells.item[ms,4]:=vauxhall_replace(u.getstring(3));  // 
          worksheet.cells.item[ms,5].NumberFormat:='@';
          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(4));  // 
          worksheet.cells.item[ms,6].NumberFormat:='@';
          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(6));  //
          worksheet.cells.item[ms,7].NumberFormat:='@';
          worksheet.cells.item[ms,7]:=u.getstring(2);  //
          if u.getstring(7)='stdplus' then begin
           if checkbox2.Checked then begin
            worksheet.cells.item[ms,2].Font.Color:=clGreen;
            worksheet.cells.item[ms,3].Font.Color:=clGreen;
            worksheet.cells.item[ms,4].Font.Color:=clGreen;
            worksheet.cells.item[ms,5].Font.Color:=clGreen;
            worksheet.cells.item[ms,6].Font.Color:=clGreen;
            worksheet.cells.item[ms,7].Font.Color:=clGreen;
           end;
          end;
          if u.getstring(7)='firmex' then begin
            worksheet.cells.item[ms,2].Font.Color:=rgb(255,153,0);
            worksheet.cells.item[ms,3].Font.Color:=rgb(255,153,0);
            worksheet.cells.item[ms,4].Font.Color:=rgb(255,153,0);
            worksheet.cells.item[ms,5].Font.Color:=rgb(255,153,0);
            worksheet.cells.item[ms,6].Font.Color:=rgb(255,153,0);
            worksheet.cells.item[ms,7].Font.Color:=rgb(255,153,0);
          end
           else begin
            if expr then begin
            worksheet.cells.item[ms,2].Font.Color:=clBlue;
            worksheet.cells.item[ms,3].Font.Color:=clBlue;
            worksheet.cells.item[ms,4].Font.Color:=clBlue;
            worksheet.cells.item[ms,5].Font.Color:=clBlue;
            worksheet.cells.item[ms,6].Font.Color:=clBlue;
            worksheet.cells.item[ms,7].Font.Color:=clBlue;
            end;
           end;
          if ansilowercase(u.getstring(5))=' ' then begin
          //   
            worksheet.cells.item[ms,3].Font.Color:=clRed;
          end;
          inc(ms);
         end;
       end;
       worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
end;

procedure ProcessFile;
begin
  if Form1.checkbox3.Checked then
      ProcessFile_new
  else
      ProcessFile_old;
end;

procedure ProcessFile_onDate_DirectionForAviasalon;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2,strp1,stdpstr:string;
  var expr,stdplus:boolean;
begin
with form1 do begin
  mcount:=0;
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g18_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex];
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;

       //    
       worksheet.cells.item[1,3].NumberFormat:='@';
       worksheet.cells.item[1,3]:=' 25  26  2018 .';
       worksheet.cells.item[1,3].Font.Size:=18;
       worksheet.cells.item[1,3].Font.Color:=clRed;

    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g18_',s)>0 then begin
//      if pos('update="update"',s)<=0 then begin  //     
      if true then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          if i<f.count then strp1:=f.getstring(i+1)
                       else strp1:='';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          if pos('  ',s1)>0 then s1:=copy(s1,1,pos('  ',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
            stdpstr:='';
            if pos('stdplus',strp1)>0 then stdpstr:='stdplus';
            if pos('vag5',strp1)>0 then stdpstr:='stdplus';
            if pos('vag11s',strp1)>0 then stdpstr:='stdplus';
          s2:=s2+#9+stdpstr;
//          s1:=getParam('days',s);
          if pos('  ',s1)<=0 then
           if length(s1)>0 then
             if not (s1[1] in ['0'..'9']) then begin
//               if pos('',s1)<=0 then t.add(s2);  //  
             end;
             t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
     rsort3(@t);
     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
          expr:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;
          worksheet.cells.item[ms,2].NumberFormat:='@';
          worksheet.cells.item[ms,2]:=prep_time(u.getstring(1));  //
          worksheet.cells.item[ms,3].NumberFormat:='@';
//          worksheet.cells.item[ms,3]:=u.getstring(5);  //  -   
          worksheet.cells.item[ms,3]:='25  26 ';  //  -   
          worksheet.cells.item[ms,4].NumberFormat:='@';
          worksheet.cells.item[ms,4]:=vauxhall_replace(u.getstring(3));  // 
          worksheet.cells.item[ms,5].NumberFormat:='@';
          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(4));  // 
          worksheet.cells.item[ms,6].NumberFormat:='@';
          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(6));  //
          worksheet.cells.item[ms,7].NumberFormat:='@';
          worksheet.cells.item[ms,7]:=u.getstring(2);  //
          if u.getstring(7)='stdplus' then begin
           if checkbox2.Checked then begin
            worksheet.cells.item[ms,2].Font.Color:=clGreen;
            worksheet.cells.item[ms,3].Font.Color:=clGreen;
            worksheet.cells.item[ms,4].Font.Color:=clGreen;
            worksheet.cells.item[ms,5].Font.Color:=clGreen;
            worksheet.cells.item[ms,6].Font.Color:=clGreen;
            worksheet.cells.item[ms,7].Font.Color:=clGreen;
           end;
          end;
          if expr then begin
            worksheet.cells.item[ms,2].Font.Color:=clBlue;
            worksheet.cells.item[ms,3].Font.Color:=clBlue;
            worksheet.cells.item[ms,4].Font.Color:=clBlue;
            worksheet.cells.item[ms,5].Font.Color:=clBlue;
            worksheet.cells.item[ms,6].Font.Color:=clBlue;
            worksheet.cells.item[ms,7].Font.Color:=clBlue;
{            worksheet.cells.item[ms,2].Font.Color:=clRed;
            worksheet.cells.item[ms,3].Font.Color:=clRed;
            worksheet.cells.item[ms,4].Font.Color:=clRed;
            worksheet.cells.item[ms,5].Font.Color:=clRed;
            worksheet.cells.item[ms,6].Font.Color:=clRed;
            worksheet.cells.item[ms,7].Font.Color:=clRed; }
          end;
          if ansilowercase(u.getstring(5))=' ' then begin
          //   
          //  worksheet.cells.item[ms,3].Font.Color:=clRed;
          end;
          inc(ms);
         end;
       end;
       worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
end;

function getstdplus(ts:AF_Types.PStrings;i:integer):boolean;
  var res:boolean;
  var n:integer;
begin
  res:=false;
  if i>0 then begin
  if i<ts.count then begin
  if pos('/>',ts.getstring(i))<=0 then begin
    for n:=i+1 to ts.count do begin
      if pos('/thread',ts.getstring(n))>0 then break
       else begin
          if pos('"stdplus"',ts.getstring(n))>0 then res:=true;
          if pos('"vag5"',ts.getstring(n))>0 then res:=true;
          if pos('"vag11s"',ts.getstring(n))>0 then res:=true;
       end;
    end;
  end;
  end;
  end;
  result:=res;
end;


procedure ProcessFile_onDate_DirectionForAviasalon2;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2,strp1,stdpstr,kgraph:string;
  var expr,stdplus:boolean;
  var strDate: string;
begin
with form1 do begin
  mcount:=0;
  kgraph:='g19';
  strDate := '29  30 ';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_'+kgraph+'_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex];
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;

       //    
       worksheet.cells.item[1,3].NumberFormat:='@';
       worksheet.cells.item[1,3]:= strDate;
       worksheet.cells.item[1,3].Font.Size:=18;
       worksheet.cells.item[1,3].Font.Color:=clRed;

    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_'+kgraph+'_',s)>0 then begin
//      if pos('update="update"',s)<=0 then begin  //     
      if true then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
//        if s1='' then begin
          if pos(' departure=',s)>0 then s1:=getParam(' departure',s)
                                  else s1:=getParam(' arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          if pos('  ',s1)>0 then s1:=copy(s1,1,pos('  ',s1)-1);
  {!!!}   //     if pos('  9',s1)>0 then s1:=copy(s1,1,pos('  9',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
  {!!!} //       if pos('  9',s1)>0 then s1:=copy(s1,1,pos('  9',s1)-1);
          stdpstr:='';
          if getstdplus(@f,i) then stdpstr:='stdplus';
{          stdpstr:='';
          if pos('stdplus',strp1)>0 then stdpstr:='stdplus';
          if pos('vag5',strp1)>0 then stdpstr:='stdplus';
          if pos('vag11s',strp1)>0 then stdpstr:='stdplus'; }
          s2:=s2+#9+stdpstr;
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
     rsort3(@t);
     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
          expr:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;
          worksheet.cells.item[ms,2].NumberFormat:='@';
          worksheet.cells.item[ms,2]:=prep_time(u.getstring(1));  //
          worksheet.cells.item[ms,3].NumberFormat:='@';
//          worksheet.cells.item[ms,3]:=u.getstring(5);  //  -   
          worksheet.cells.item[ms,3]:=strDate;  //  -   
          worksheet.cells.item[ms,4].NumberFormat:='@';
          worksheet.cells.item[ms,4]:=vauxhall_replace(u.getstring(3));  // 
          worksheet.cells.item[ms,5].NumberFormat:='@';
          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(4));  // 
          worksheet.cells.item[ms,6].NumberFormat:='@';
          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(6));  //
          worksheet.cells.item[ms,7].NumberFormat:='@';
          worksheet.cells.item[ms,7]:=u.getstring(2);  //
          if u.getstring(7)='stdplus' then begin
           if checkbox2.Checked then begin
            worksheet.cells.item[ms,2].Font.Color:=clGreen;
            worksheet.cells.item[ms,3].Font.Color:=clGreen;
            worksheet.cells.item[ms,4].Font.Color:=clGreen;
            worksheet.cells.item[ms,5].Font.Color:=clGreen;
            worksheet.cells.item[ms,6].Font.Color:=clGreen;
            worksheet.cells.item[ms,7].Font.Color:=clGreen;
           end;
          end;
          if expr then begin
            worksheet.cells.item[ms,2].Font.Color:=clBlue;
            worksheet.cells.item[ms,3].Font.Color:=clBlue;
            worksheet.cells.item[ms,4].Font.Color:=clBlue;
            worksheet.cells.item[ms,5].Font.Color:=clBlue;
            worksheet.cells.item[ms,6].Font.Color:=clBlue;
            worksheet.cells.item[ms,7].Font.Color:=clBlue;
          end;
          if ansilowercase(u.getstring(5))=' ' then begin
          //   
//            worksheet.cells.item[ms,3].Font.Color:=clRed;
          end;
          inc(ms);
         end;
       end;
       worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
end;





procedure ProcessFileOnDate;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2:string;
  var expr:boolean;
begin
with form1 do begin
  mcount:=0;
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g14_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex];
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;
       //    
       worksheet.cells.item[1,3].NumberFormat:='@';
       worksheet.cells.item[1,3]:='14 ';
       worksheet.cells.item[1,3].Font.Size:=18;
       worksheet.cells.item[1,3].Font.Color:=clRed;
    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g14_',s)>0 then begin
//      if pos('update="update"',s)<=0 then begin  //     
      if true then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos(' - ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          if pos('  ',s1)>0 then s1:=copy(s1,1,pos('  ',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('platform',s);
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
           if length(s1)>0 then
//             if not (s1[1] in ['0'..'9']) then t.add(s2);  //  
             t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
//     rsort3(@t);
     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
          expr:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;
          worksheet.cells.item[ms,2].NumberFormat:='@';
          worksheet.cells.item[ms,2]:=prep_time(u.getstring(1));  //
          worksheet.cells.item[ms,3].NumberFormat:='@';
//          worksheet.cells.item[ms,3]:=u.getstring(5);  //  -   
//          worksheet.cells.item[ms,3]:=u.getstring(7); //
          worksheet.cells.item[ms,3]:='14 '; //
          worksheet.cells.item[ms,4].NumberFormat:='@';
          worksheet.cells.item[ms,4]:=vauxhall_replace(u.getstring(3));  // 
          worksheet.cells.item[ms,5].NumberFormat:='@';
          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(4));  // 
          worksheet.cells.item[ms,6].NumberFormat:='@';
          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(6));  //
          worksheet.cells.item[ms,7].NumberFormat:='@';
          worksheet.cells.item[ms,7]:=u.getstring(2);  //
          if expr then begin
            worksheet.cells.item[ms,2].Font.Color:=clBlue;
            worksheet.cells.item[ms,3].Font.Color:=clBlue;
            worksheet.cells.item[ms,4].Font.Color:=clBlue;
            worksheet.cells.item[ms,5].Font.Color:=clBlue;
            worksheet.cells.item[ms,6].Font.Color:=clBlue;
            worksheet.cells.item[ms,7].Font.Color:=clBlue;
          end;
          if ansilowercase(u.getstring(5))=' ' then begin
            worksheet.cells.item[ms,3].Font.Color:=clRed;
          end;
          inc(ms);
         end;
       end;
       worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
end;






procedure ProcessFile_Chg;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2:string;
  var expr,stdplus:boolean;
begin
with form1 do begin
  mcount:=0;
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g17_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex];
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;

       //    
   //    worksheet.cells.item[1,3].NumberFormat:='@';
   //    worksheet.cells.item[1,3]:='28  - 9  2016 .';
   //    worksheet.cells.item[1,3].Font.Size:=18;
   //    worksheet.cells.item[1,3].Font.Color:=clRed;

    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g17_',s)>0 then begin
//      if pos('update="update"',s)<=0 then begin  //     
      if true then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure=',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('except',s);
          s2:=s2+#9+s1;
          s1:=getParam('departure_platform',s);
          s2:=s2+#9+s1;
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
     rsort3(@t);
     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
          expr:=false;
          stdplus:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;
          worksheet.cells.item[ms,2].NumberFormat:='@';
          worksheet.cells.item[ms,2]:=prep_time(u.getstring(1));  //
          s2:=u.getstring(5);
          if validstr(u.getstring(7)) then s2:=s2+',  '+u.getstring(7);
          worksheet.cells.item[ms,3].NumberFormat:='@';
          worksheet.cells.item[ms,3]:=u.getstring(8);  //
          worksheet.cells.item[ms,4].NumberFormat:='@';
          worksheet.cells.item[ms,4]:=s2;  // 
          worksheet.cells.item[ms,5].NumberFormat:='@';
          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(3));  // 
          worksheet.cells.item[ms,6].NumberFormat:='@';
          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(4));  // 
          worksheet.cells.item[ms,7].NumberFormat:='@';
          worksheet.cells.item[ms,7]:=vauxhall_replace(u.getstring(6));  //
          worksheet.cells.item[ms,8].NumberFormat:='@';
          worksheet.cells.item[ms,8]:=u.getstring(2);  //
          if expr then begin
            worksheet.cells.item[ms,2].Font.Color:=clBlue;
            worksheet.cells.item[ms,3].Font.Color:=clBlue;
            worksheet.cells.item[ms,4].Font.Color:=clBlue;
            worksheet.cells.item[ms,5].Font.Color:=clBlue;
            worksheet.cells.item[ms,6].Font.Color:=clBlue;
            worksheet.cells.item[ms,7].Font.Color:=clBlue;
            worksheet.cells.item[ms,8].Font.Color:=clBlue;
          end;
          inc(ms);
         end;
       end;
       worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
end;





function prepexcept(s:string):string;
  var f,u,z1,z2:AF_Types.TSTrings;
  var i,g1,g2:integer;
  var lasts,zc:string;
begin
  f.create; u.create; z1.create; z2.create;
  ParseCSVStrEx(@f,s,',');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      ParseCSVStrEx(@u,f.getstring(i),'.');
      if u.count>1 then begin
        g1:=strtointe(u.getstring(1));
        g2:=strtointe(u.getstring(2));
        if g1>=20 then begin
         z1.add(u.getstring(1));
         z2.add(u.getstring(2));
        end;
      end;
    end;
  end;
  s:='';
  if z1.count>0 then begin
   s:='';
   lasts:='';

   for i:=z1.count downto 1 do begin
   zc:=z2.getstring(i);
   zc:=StrReplace(zc,'01','');
   zc:=StrReplace(zc,'02','');
   zc:=StrReplace(zc,'03','');
   zc:=StrReplace(zc,'04','');
   zc:=StrReplace(zc,'05','');
   zc:=StrReplace(zc,'06','');
   zc:=StrReplace(zc,'07','');
   zc:=StrReplace(zc,'08','');
   zc:=StrReplace(zc,'09','');
   zc:=StrReplace(zc,'10','');
   zc:=StrReplace(zc,'11','');
   zc:=StrReplace(zc,'12','');
     if zc<>lasts then begin
       s:=z1.getstring(i)+' '+zc+', '+s;;
     end
      else begin
       s:=z1.getstring(i)+', '+s;
      end;
     lasts:=zc;
   end;
   if length(s)>2 then s:=copy(s,1,length(s)-2);
  end;
  f.free; u.free; z1.free; z2.free;
  result:=s;
end;






procedure ProcessFile_All;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,mcount,xm:integer;
  var f,dl,t,u:AF_Types.TStrings;
  var s,s1,s2,excp:string;
  var expr:boolean;
begin
 ShowMessage('Error!');
(*
with form1 do begin
  showmessage('Process_File_All');
  mcount:=0;
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g13_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    IIndex := 1;
    XLApp.Connect;
    XLApp.WorkBooks.Add(xlWBatWorkSheet,0);
    WorkBk := XLApp.WorkBooks.Item[IIndex];
    WorkSheet := WorkBk.WorkSheets.Get_Item(1) as _WorkSheet;
    WorkSheet.Cells.SpecialCells(xlCellTypeLastCell,EmptyParam).Activate;
    ms:=3;
    worksheet.cells.item[1,1].NumberFormat:='@';
    worksheet.cells.item[1,1]:=ComboBox2.Items[Combobox2.ItemIndex]+' (  31 )';
    worksheet.cells.item[1,1].Font.Size:=18;
    worksheet.cells.item[1,1].Font.Color:=clBlue;
    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      xm:=1;
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g13_',s)>0 then begin
      if {pos('update="update"',s)<=0}true then begin  //     
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos(' - ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          excp:=getParam('except',s);
           if validstr(excp) then begin
            if validstr(prepexcept(excp)) then begin
             excp:=',  '+prepexcept(excp);
            end
             else begin
              excp:='';
             end;
           end;
          s1:=getParam('days',s);
           if ((pos('1.',s1)>0)or(pos('2.',s1)>0)or(pos('3.',s1)>0)or(pos('4.',s1)>0)or(pos('5.',s1)>0)or(pos('6.',s1)>0)or(pos('7.',s1)>0)or(pos('8.',s1)>0)or(pos('9.',s1)>0)) then begin
            if validstr(prepexcept(s1)) then begin
             s1:=' '+prepexcept(s1);
             xm:=1;
            end
             else begin
               s1:=' NONE';
               xm:=0;
             end;
           end;
//          if pos(', c1',s1)>0 then s1:=copy(s1,1,pos(', c1',s1)-1);
          s2:=s2+#9+s1+excp;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1+#9+inttostr(xm);
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
     rsort3(@t);
//     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
       worksheet.cells.item[ms,1].NumberFormat:='@';
       worksheet.cells.item[ms,1]:=dl.getstring(n);
       worksheet.cells.item[ms,1].Font.Size:=14;
       worksheet.cells.item[ms,1].Font.Color:=clRed;
       inc(ms);
       for i:=1 to t.count do begin
         inc(mcount);
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
         if u.getstring(7)<>'0' then begin
          expr:=false;
          if validstr(u.getstring(2)) then begin
           if u.getstring(2)[1]='7' then expr:=true;
          end;
          worksheet.cells.item[ms,2].NumberFormat:='@';
          worksheet.cells.item[ms,2]:=prep_time(u.getstring(1));  //
          worksheet.cells.item[ms,3].NumberFormat:='@';
          worksheet.cells.item[ms,3]:=u.getstring(5);  // 
          worksheet.cells.item[ms,4].NumberFormat:='@';
          worksheet.cells.item[ms,4]:=vauxhall_replace(u.getstring(3));  // 
          worksheet.cells.item[ms,5].NumberFormat:='@';
          worksheet.cells.item[ms,5]:=vauxhall_replace(u.getstring(4));  // 
          worksheet.cells.item[ms,6].NumberFormat:='@';
          worksheet.cells.item[ms,6]:=vauxhall_replace(u.getstring(6));  //
          worksheet.cells.item[ms,7].NumberFormat:='@';
          worksheet.cells.item[ms,7]:=u.getstring(2);  //
          if expr then begin
            worksheet.cells.item[ms,2].Font.Color:=clBlue;
            worksheet.cells.item[ms,3].Font.Color:=clBlue;
            worksheet.cells.item[ms,4].Font.Color:=clBlue;
            worksheet.cells.item[ms,5].Font.Color:=clBlue;
            worksheet.cells.item[ms,6].Font.Color:=clBlue;
            worksheet.cells.item[ms,7].Font.Color:=clBlue;
          end;
          if ansilowercase(u.getstring(5))=' ' then begin
            worksheet.cells.item[ms,3].Font.Color:=clRed;
          end;
          inc(ms);
         end;
         end;
       end;
       worksheet.Columns.AutoFit;
       inc(ms);
     end;
    end; //n
    ForceDirectories(workdir+combobox1.items[combobox1.itemindex]+'\');
    WorkBk.SaveAs(workdir+combobox1.items[combobox1.itemindex]+'\'+PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+').xls',xlWorkbookNormal, EmptyParam, EmptyParam, false, false,
                xlNoChange, xlUserResolution, false, EmptyParam, EmptyParam, EmptyParam, 0);
    WorkBk.Close(true,EmptyParam,EmptyParam,0);
    XLApp.Quit;
    XLApp.Disconnect;

  end;
  mlog.add(PrepFn(combobox2.items[combobox2.itemindex])+' ('+stc.getstring(combobox2.ItemIndex+1)+') = '+inttostr(mcount));
  f.free; dl.free; t.free; u.free;
end;
*)
end;

















procedure ProcessFile_Aviasalon;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,z:integer;
  var f,dl,t,u,f2:AF_Types.TStrings;
  var s,s1,s2:string;
begin
with form1 do begin
  f2.create;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  stringgrid1.ColCount:=16;
  stringgrid1.RowCount:=600;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g22_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    ms:=3;
    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g22_',s)>0 then begin
      if pos('update="235235update"',s)<=0 then begin
//      if pos('update="update"',s)<=0 then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
//          if pos(', c27',s1)>0 then s1:=copy(s1,1,pos(', c27',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('uid',s);
          s2:=s2+#9+s1;
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
//     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
//       worksheet.cells.item[ms,1]:=dl.getstring(n);
       inc(ms);
       for i:=1 to t.count do begin
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
{          worksheet.cells.item[ms,2]:=u.getstring(2);
          worksheet.cells.item[ms,3]:=u.getstring(1);
          worksheet.cells.item[ms,4]:=u.getstring(3);
          worksheet.cells.item[ms,5]:=u.getstring(4);
          worksheet.cells.item[ms,6]:=u.getstring(5);
          worksheet.cells.item[ms,7]:=u.getstring(6);
}
          StringGrid1.Cells[0,ms]:=u.getstring(2);
          StringGrid1.Cells[1,ms]:=u.getstring(1);
          StringGrid1.Cells[2,ms]:=u.getstring(3);
          StringGrid1.Cells[3,ms]:=u.getstring(4);
          StringGrid1.Cells[4,ms]:=dl.getstring(n);
          StringGrid1.Cells[5,ms]:=u.getstring(7);
          if true then begin
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');
            GetInetFile(yserver+'/export/suburban/thread/'+u.getstring(7)+'/',workdir+'station4.xml.tmp');
             if fileexists(workdir+'station4.xml.tmp') then begin
              UTF8FileDecode(workdir+'station4.xml.tmp',workdir+'station5.xml.tmp');
              XMLFile1(workdir+'station5.xml.tmp',workdir+'station6.xml.tmp');
              f2.loadfromfile(workdir+'station6.xml.tmp');
              if f2.count>0 then begin
               for x:=1 to f2.count do begin
                 s:=f2.getstring(x);
                 if pos('<rtstation',s)>0 then begin
                   s1:=getParam('esr',s);
                   if s1='194013' then begin    //
                     if dl.getstring(n)=' ' then StringGrid1.Cells[6,ms]:=getParam('departure_local',s)
                                                    else StringGrid1.Cells[6,ms]:=getParam('arrival_local',s)
                   end;
                   if s1='194028' then begin    //-
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('departure_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                   end;
                   if s1='193913' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('departure_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                   end;
                   if s1='193839' then begin    //
                     if dl.getstring(n)=' ' then begin
                                                      if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('departure_local',s) else StringGrid1.Cells[9,ms]:='&mdash;';
                                                       s2:=getParam('platform',s);
                                                       StringGrid1.Cells[13,ms]:=s2;
                                                    end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[9,ms]:='&mdash;'; end
                   end;
                   if s1='194206' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('departure_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                   end;
                   if s1='194827' then begin    //
                     if ((dl.getstring(n)=' ')or(dl.getstring(n)='')) then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('departure_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                   end;
                   if s1='194846' then begin    //42 
                     if ((dl.getstring(n)=' ')or(dl.getstring(n)='')) then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('departure_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                   end;
                 end;
               end;
              end;
             end
              else ShowMessage('          .      ,     !');
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');

          end;

          inc(ms);
         end;
       end;
       inc(ms);
     end; //t.count

     f2.clear;
     for i:=0 to stringgrid1.RowCount-1 do begin
      s:=stringgrid1.Cells[0,i];
      for z:=1 to StringGrid1.ColCount-1 do begin
        s:=s+#9+stringgrid1.Cells[z,i];
      end;
      f2.add(s);
     end;
     f2.savetofile('C:\1\aviasalon.tsv');

    end; //n

  end;


  f.free; dl.free; t.free; u.free;
  f2.free;
end;
end;




procedure ProcessFile_Borodino;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,z:integer;
  var f,dl,t,u,f2:AF_Types.TStrings;
  var s,s1,s2:string;
begin
with form1 do begin
  f2.create;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  stringgrid1.ColCount:=16;
  stringgrid1.RowCount:=600;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g18',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    ms:=3;
    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g18',s)>0 then begin
      if true then begin
//      if pos('update="update"',s)<=0 then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos('  ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
//          if pos(', c1 ',s1)>0 then s1:=copy(s1,1,pos(', c1 ',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('uid',s);
          s2:=s2+#9+s1;
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
//     t.savetofile('c:\1\42\'+inttostr(n)+'.txt');
     if t.count>0 then begin
//       worksheet.cells.item[ms,1]:=dl.getstring(n);
       inc(ms);
       for i:=1 to t.count do begin
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
{          worksheet.cells.item[ms,2]:=u.getstring(2);
          worksheet.cells.item[ms,3]:=u.getstring(1);
          worksheet.cells.item[ms,4]:=u.getstring(3);
          worksheet.cells.item[ms,5]:=u.getstring(4);
          worksheet.cells.item[ms,6]:=u.getstring(5);
          worksheet.cells.item[ms,7]:=u.getstring(6);
}
          StringGrid1.Cells[0,ms]:=u.getstring(2);
          StringGrid1.Cells[1,ms]:=u.getstring(1);
          StringGrid1.Cells[2,ms]:=u.getstring(3);
          StringGrid1.Cells[3,ms]:=u.getstring(4);
          StringGrid1.Cells[4,ms]:=dl.getstring(n);
          StringGrid1.Cells[5,ms]:=u.getstring(7);
          if true then begin
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');
            GetInetFile(yserver+'/export/suburban/thread/'+u.getstring(7)+'/',workdir+'station4.xml.tmp');
             if fileexists(workdir+'station4.xml.tmp') then begin
              UTF8FileDecode(workdir+'station4.xml.tmp',workdir+'station5.xml.tmp');
              XMLFile1(workdir+'station5.xml.tmp',workdir+'station6.xml.tmp');
              f2.loadfromfile(workdir+'station6.xml.tmp');
//              f2.savetofile('c:\1\42\'+u.getstring(7)+'.txt');
              if f2.count>0 then begin
               for x:=1 to f2.count do begin
                 s:=f2.getstring(x);
                 if pos('<rtstation',s)>0 then begin
                   s1:=getParam('esr',s);
                   if s1='198230' then begin    //
                     if ((dl.getstring(n)='')or(dl.getstring(n)=' ')) then StringGrid1.Cells[6,ms]:=getParam('departure_local',s)
                                                    else StringGrid1.Cells[6,ms]:=getParam('arrival_local',s)
                   end;
                   if s1='198211' then begin    //
                     if ((dl.getstring(n)='')or(dl.getstring(n)=' ')) then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('departure_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                   end;
                   if s1='181600' then begin    //
                     if ((dl.getstring(n)='')or(dl.getstring(n)=' ')) then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('departure_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                   end;
                   if s1='181704' then begin    //
                     if ((dl.getstring(n)='')or(dl.getstring(n)=' ')) then begin
                                                      if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('departure_local',s) else StringGrid1.Cells[9,ms]:='&mdash;';
                                                       s2:=getParam('platform',s);
                                                       StringGrid1.Cells[13,ms]:=s2;
                                                    end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[9,ms]:='&mdash;'; end
                   end;
                   if s1='182209' then begin    //
                     if ((dl.getstring(n)='')or(dl.getstring(n)=' ')) then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('departure_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                   end;
                   if s1='183201' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                                                    else begin
                                                     if dl.getstring(n)='' then begin
                                                      if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[11,ms]:='&mdash;';
                                                     end
                                                      else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('departure_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end

                                                    end;
                   end;
                   if s1='175807' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('departure_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                   end;
                 end;
               end;
              end;
             end
              else ShowMessage('          .      ,     !');
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');

          end;

          inc(ms);
         end;
       end;
       inc(ms);
     end; //t.count

     f2.clear;
     for i:=0 to stringgrid1.RowCount-1 do begin
      s:=stringgrid1.Cells[0,i];
      for z:=1 to StringGrid1.ColCount-1 do begin
        s:=s+#9+stringgrid1.Cells[z,i];
      end;
      f2.add(s);
     end;
     f2.savetofile('C:\1\29\borodino2018.tsv');

    end; //n

  end;


  f.free; dl.free; t.free; u.free;
  f2.free;
end;
end;






procedure ProcessFile_KonMoh;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,z:integer;
  var f,dl,t,u,f2:AF_Types.TStrings;
  var s,s1,s2:string;
begin
with form1 do begin
  f2.create;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  stringgrid1.ColCount:=16;
  stringgrid1.RowCount:=600;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g17_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    ms:=3;
    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g17_',s)>0 then begin
      if pos('update="235235update"',s)<=0 then begin
//      if pos('update="update"',s)<=0 then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos(' - ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s)+' : '+getParam('except',s);
//          if pos(', c1 ',s1)>0 then s1:=copy(s1,1,pos(', c1 ',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('uid',s);
          s2:=s2+#9+s1;
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
//     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
//       worksheet.cells.item[ms,1]:=dl.getstring(n);
       inc(ms);
       for i:=1 to t.count do begin
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
{          worksheet.cells.item[ms,2]:=u.getstring(2);
          worksheet.cells.item[ms,3]:=u.getstring(1);
          worksheet.cells.item[ms,4]:=u.getstring(3);
          worksheet.cells.item[ms,5]:=u.getstring(4);
          worksheet.cells.item[ms,6]:=u.getstring(5);
          worksheet.cells.item[ms,7]:=u.getstring(6);
}
          StringGrid1.Cells[0,ms]:=u.getstring(2);
          StringGrid1.Cells[1,ms]:=u.getstring(1);
          StringGrid1.Cells[2,ms]:=u.getstring(3);
          StringGrid1.Cells[3,ms]:=u.getstring(4);
          StringGrid1.Cells[4,ms]:=dl.getstring(n);
          StringGrid1.Cells[5,ms]:=u.getstring(6);
          if true then begin
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');
            GetInetFile(yserver+'/export/suburban/thread/'+u.getstring(6)+'/',workdir+'station4.xml.tmp');
             if fileexists(workdir+'station4.xml.tmp') then begin
              UTF8FileDecode(workdir+'station4.xml.tmp',workdir+'station5.xml.tmp');
              XMLFile1(workdir+'station5.xml.tmp',workdir+'station6.xml.tmp');
              f2.loadfromfile(workdir+'station6.xml.tmp');
              if f2.count>0 then begin
               for x:=1 to f2.count do begin
                 s:=f2.getstring(x);
                 if pos('<rtstation',s)>0 then begin
                   s1:=getParam('esr',s);
                   if s1='060073' then begin    //
                     if dl.getstring(n)<>' ' then StringGrid1.Cells[6,ms]:=getParam('departure_local',s)
                                                    else StringGrid1.Cells[6,ms]:=getParam('arrival_local',s)
                   end;
                   if s1='060048' then begin    //-
                     if dl.getstring(n)<>' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('departure_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                   end;
                   if s1='060001' then begin    //
                     if dl.getstring(n)<>' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('departure_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                   end;
                   if s1='060302' then begin    //
                     if dl.getstring(n)<>' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('departure_local',s) else StringGrid1.Cells[9,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[9,ms]:='&mdash;'; end
                   end;
                   if s1='060500' then begin    //
                     if dl.getstring(n)<>' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('departure_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                   end;
                   if s1='060800' then begin    //
                     if dl.getstring(n)<>' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('departure_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                   end;
                   if s1='060904' then begin    //
                     if dl.getstring(n)<>' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('departure_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                   end;
                   if s1='061131' then begin    //.
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[13,ms]:=getParam('departure_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[13,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[13,ms]:='&mdash;'; end
                   end;
                 end;
               end;
              end;
             end
              else ShowMessage('          .      ,     !');
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');

          end;

          inc(ms);
         end;
       end;
       inc(ms);
     end; //t.count

     f2.clear;
     for i:=0 to stringgrid1.RowCount-1 do begin
      s:=stringgrid1.Cells[0,i];
      for z:=1 to StringGrid1.ColCount-1 do begin
        s:=s+#9+stringgrid1.Cells[z,i];
      end;
      f2.add(s);
     end;
     f2.savetofile('C:\1\7.tsv');
     t.savetofile('C:\1\7a.tsv');

    end; //n

  end;


  f.free; dl.free; t.free; u.free;
  f2.free;
end;
end;






procedure ProcessFile_Podolsk;
  var WorkBk : _WorkBook;
  var WorkSheet : _WorkSheet;
  var IIndex : OleVariant;
  var i,n,x,ms,z:integer;
  var f,dl,t,u,f2:AF_Types.TStrings;
  var s,s1,s2:string;
begin
with form1 do begin
  f2.create;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  stringgrid1.ColCount:=16;
  stringgrid1.RowCount:=600;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  f.create; dl.create; t.create; u.create;
  f.loadfromfile(workdir+'station3.xml.tmp');
  if f.count>0 then begin
    for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g12_',s)>0 then begin
        s1:=getParam('direction',s);
        if dl.SearchString(s1)<=0 then dl.add(s1);
      end;
      end;
    end;
    dl.SortedAsString;
    ms:=3;
    for n:=1 to dl.count do begin
     t.clear;
     for i:=1 to f.count do begin
      s:=f.getstring(i);
      if pos('<thread ',s)>0 then begin
      if pos('_g12_',s)>0 then begin
      if pos('update="235235update"',s)<=0 then begin
//      if pos('update="update"',s)<=0 then begin
        s1:=getParam('direction',s);
        if s1=dl.GetString(n) then begin
          if pos('departure',s)>0 then s1:=getParam('departure',s)
                                  else s1:=getParam('arrival',s);
          while pos(':',s1)>0 do s1[pos(':',s1)]:='-';
          s2:=s1;
          s1:=getParam('number',s);
          s2:=s2+#9+s1;
          s1:=getParam('title',s);
          x:=pos(' - ',s1);
          if x>1 then begin
           Delete(s1,x,3);
           Insert(#9,s1,x);
          end;
          s2:=s2+#9+s1;
          s1:=getParam('days',s);
          if pos(', c27',s1)>0 then s1:=copy(s1,1,pos(', c27',s1)-1);
          s2:=s2+#9+s1;
          s1:=getParam('stops',s);
          s2:=s2+#9+s1;
          s1:=getParam('uid',s);
          s2:=s2+#9+s1;
          t.add(s2);
        end;
      end;
      end;
      end;
     end; //i
     t.SortedAsString;
//     t.savetofile(workdir+inttostr(n)+'.txt');
     if t.count>0 then begin
//       worksheet.cells.item[ms,1]:=dl.getstring(n);
       inc(ms);
       for i:=1 to t.count do begin
         ParseCSVStrEx(@u,t.getstring(i),#9);
         if u.count>0 then begin
{          worksheet.cells.item[ms,2]:=u.getstring(2);
          worksheet.cells.item[ms,3]:=u.getstring(1);
          worksheet.cells.item[ms,4]:=u.getstring(3);
          worksheet.cells.item[ms,5]:=u.getstring(4);
          worksheet.cells.item[ms,6]:=u.getstring(5);
          worksheet.cells.item[ms,7]:=u.getstring(6);
}
          StringGrid1.Cells[0,ms]:=u.getstring(2);
          StringGrid1.Cells[1,ms]:=u.getstring(1);
          StringGrid1.Cells[2,ms]:=u.getstring(3);
          StringGrid1.Cells[3,ms]:=u.getstring(4);
          StringGrid1.Cells[4,ms]:=dl.getstring(n);
          StringGrid1.Cells[5,ms]:=u.getstring(7);
          if true then begin
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');
            GetInetFile(yserver+'/export/suburban/thread/'+u.getstring(7)+'/',workdir+'station4.xml.tmp');
             if fileexists(workdir+'station4.xml.tmp') then begin
              UTF8FileDecode(workdir+'station4.xml.tmp',workdir+'station5.xml.tmp');
              XMLFile1(workdir+'station5.xml.tmp',workdir+'station6.xml.tmp');
              f2.loadfromfile(workdir+'station6.xml.tmp');
              if f2.count>0 then begin
               for x:=1 to f2.count do begin
                 s:=f2.getstring(x);
                 if pos('<rtstation',s)>0 then begin
                   s1:=getParam('esr',s);
                   if s1='198230' then begin    //
                     if dl.getstring(n)=' ' then StringGrid1.Cells[6,ms]:=getParam('departure_local',s)
                                                    else StringGrid1.Cells[6,ms]:=getParam('arrival_local',s)
                   end;
                   if s1='198211' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('departure_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[7,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[7,ms]:='&mdash;'; end
                   end;
                   if s1='181600' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('departure_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[8,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[8,ms]:='&mdash;'; end
                   end;
                   if s1='181704' then begin    //
                     if dl.getstring(n)=' ' then begin
                                                      if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('departure_local',s) else StringGrid1.Cells[9,ms]:='&mdash;';
                                                       s2:=getParam('platform',s);
                                                       StringGrid1.Cells[13,ms]:=s2;
                                                    end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[9,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[9,ms]:='&mdash;'; end
                   end;
                   if s1='182209' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('departure_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[10,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[10,ms]:='&mdash;'; end
                   end;
                   if s1='183201' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[11,ms]:=getParam('departure_local',s) else StringGrid1.Cells[11,ms]:='&mdash;'; end
                   end;
                   if s1='175807' then begin    //
                     if dl.getstring(n)=' ' then begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('arrival_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                                                    else begin if getParam('departure',s)<>getParam('arrival',s) then StringGrid1.Cells[12,ms]:=getParam('departure_local',s) else StringGrid1.Cells[12,ms]:='&mdash;'; end
                   end;
                 end;
               end;
              end;
             end
              else ShowMessage('          .      ,     !');
            if fileexists(workdir+'station4.xml.tmp') then DeleteFile(workdir+'station4.xml.tmp');
            if fileexists(workdir+'station5.xml.tmp') then DeleteFile(workdir+'station5.xml.tmp');
            if fileexists(workdir+'station6.xml.tmp') then DeleteFile(workdir+'station6.xml.tmp');

          end;

          inc(ms);
         end;
       end;
       inc(ms);
     end; //t.count

     f2.clear;
     for i:=0 to stringgrid1.RowCount-1 do begin
      s:=stringgrid1.Cells[0,i];
      for z:=1 to StringGrid1.ColCount-1 do begin
        s:=s+#9+stringgrid1.Cells[z,i];
      end;
      f2.add(s);
     end;
     f2.savetofile('C:\1\ 31\2.tsv');

    end; //n

  end;


  f.free; dl.free; t.free; u.free;
  f2.free;
end;
end;








procedure TForm1.FormCreate(Sender: TObject);
  var f,u:AF_Types.TSTrings;
  var i:integer;
begin
  mlog.create;
  stc.create;
  f.create; u.create;
  workdir:=DeleteSlasheEx(ExtractDirPath(Application.ExeName))+'\';
  GetMaskList(workdir+'*.dir',@f);
  if f.count>0 then begin
    for i:=1 to f.count do ComboBox1.Items.Add(extractfilename(f.getstring(i)));
    combobox1.itemindex:=0;
    LoadDirection;
  end;
  f.free; u.free;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  mlog.free;
  stc.free;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  LoadDirection;
end;


procedure TForm1.Button1Click(Sender: TObject);
var srv_adress:String;
begin
  if combobox2.ItemIndex>=0 then begin
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');

  srv_adress  := '';
  if Form1.checkbox4.Checked then
     srv_adress :=  yserverv2_tst
  else
     srv_adress :=  yserverv2;

  GetInetFile(srv_adress+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1){+'?date=2015-08-29'},workdir+'station1.xml.tmp');
  //  GetInetFile('https://testing.export.rasp.yandex.net/export/v2/suburban/station/'+stc.getstring(combobox2.ItemIndex+1)+'?add_subtypes=true&date=2021-09-12',workdir+'station1.xml.tmp');
  //        -  ProcessFile      !
//  s1:=yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1);

  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then begin
                                               if checkbox1.checked then ProcessFile_All
                                                                    else ProcessFile;
                                             end;
//   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
//   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
//   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
   showmessage('!');
  end
   else ShowMessage('          .      ,     !');
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
 var i,n:integer;
begin
 if combobox2.ItemIndex>=0 then begin
 for n:=0 to combobox1.items.count-1 do begin
 mlog.clear;
 combobox1.ItemIndex:=n;
 LoadDirection;
 for i:=0 to combobox2.items.count-1 do begin
  combobox2.ItemIndex:=i;
  ForceDirectories(workdir+combobox1.items[combobox1.itemindex]);
  delay(1000);
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
//  GetInetFile(yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1),workdir+'station1.xml.tmp');
  GetInetFile(yserverv2+'/export/v2/suburban/station/'+stc.getstring(combobox2.ItemIndex+1)+'?add_subtypes=true'{+'&date=2015-10-02'},workdir+'station1.xml.tmp');
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then begin
                                               if checkbox1.checked then ProcessFile_All
                                                                    else ProcessFile;
                                             end;
   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 end;
 mlog.savetofile(deleteslasheex(workdir+combobox1.items[combobox1.itemindex])+'\log.txt');
 end;
 showmessage('!');
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
 var i,n:integer;
// var s1:string;
 var srv_adress:String;
begin
   srv_adress  := '';
  if Form1.checkbox4.Checked then
     srv_adress :=  yserverv2_tst
  else
     srv_adress :=  yserverv2;

 mlog.clear;
 if combobox2.ItemIndex>=0 then begin
 for i:=0 to combobox2.items.count-1 do begin
  delay(1000);
  application.processmessages;
  combobox2.ItemIndex:=i;
  ForceDirectories(workdir+combobox1.items[combobox1.itemindex]);
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');

  GetInetFile(srv_adress+'/export/v2/suburban/station/'+stc.getstring(combobox2.ItemIndex+1)+'?add_subtypes=true'{+'&date=2015-10-02'},workdir+'station1.xml.tmp');
  //        -  ProcessFile      !
//  s1:=yserver2+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1);
//  InputQuery('','',s1);
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then begin
                                               if checkbox1.checked then ProcessFile_All
                                                                    else ProcessFile;
                                             end;
   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 end;
 mlog.savetofile(deleteslasheex(workdir+combobox1.items[combobox1.itemindex])+'\log.txt');
 showmessage('!');
 end;
end;

procedure TForm1.Button4Click(Sender: TObject);
 var s:string;
begin
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
//  GetInetFile(yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1),workdir+'station1.xml.tmp');
  GetInetFile(yserver+'/export/suburban/station/183201?date=2018-09-01',workdir+'station1.xml.tmp');
{  s:=yserver+'/export/suburban/station/61131?date=2013-07-05';
  InputQuery('','',s);}
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then ProcessFile_Borodino;
   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 showmessage('!');
end;

function AviasalonSt(s:string; m:integer):string;
begin
 if s='' then s:='';
 if s='' then s:='';
 if s='' then s:='';
 if s='' then s:='';
 if s='' then s:='';
 if s='-1' then s:='-1';
 if s='-2' then s:='-2';
 if m=1 then result:=' '+s
        else result:=' '+s;
end;

procedure TForm1.Button5Click(Sender: TObject);
  var f2,u,f3:AF_Types.TStrings;
  var i,n:integer;
  var clr,clr1,expr,p1,p2:string;
begin
  //
  f2.create; u.create; f3.create;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  stringgrid1.ColCount:=16;
  stringgrid1.RowCount:=600;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';

  f2.loadfromfile('C:\1\aviasalon.tsv');
  for i:=1 to f2.count do begin
   ParseCSVStrEx(@u,f2.getstring(i),#9);
   if u.getstring(5)=' ' then begin
     if u.getstring(1)[1]='7' then begin clr:='<font color="#ff0000">'; clr1:='</font>'; expr:=''; end
                              else begin clr:=''; clr1:=''; expr:=''; end;
     if u.getstring(14)='3 ' then begin p1:='<u>'; p2:='</u>' end
                              else begin p1:=''; p1:=''; end;
     f3.add('<tr>');
     f3.add('    <td>'+clr+AviasalonSt(u.getstring(4),1)+clr1+'</td>');
     f3.add('    <td><strong>'+clr+u.getstring(7)+clr1+'</strong></td>');
     f3.add('    <td>'+clr+''+u.getstring(8)+clr1+'</td>');
     f3.add('    <td>'+clr+''+u.getstring(9)+clr1+'</td>');
     f3.add('    <td><strong>'+clr+p1+u.getstring(10)+p2+clr1+'</strong></td>');
     f3.add('    <td>'+clr+''+u.getstring(11)+clr1+'</td>');
     f3.add('    <td>'+clr+'&rarr;'+clr1+'</td>');
     f3.add('    <td>'+clr+'<strong>'+u.getstring(12)+'</strong>'+clr1+'</td>');
     f3.add('    <td>'+clr+'<strong>'+u.getstring(13)+'</strong>'+clr1+'</td>');
     f3.add('    <td>'+clr+''+expr+clr1+'</td>');
     f3.add('</tr>');
   end;
  end;
  f3.savetofile('C:\1\3.txt');
  showmessage('end!');

  f2.free; u.free; f3.free;
end;

procedure TForm1.Button6Click(Sender: TObject);
  var f2,u,f3:AF_Types.TStrings;
  var i,n:integer;
  var clr,clr1,expr,p1,p2:string;
begin
  //
  f2.create; u.create; f3.create;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';
  stringgrid1.ColCount:=16;
  stringgrid1.RowCount:=600;
  for i:=0 to stringgrid1.ColCount-1 do
   for n:=0 to StringGrid1.RowCount-1 do StringGrid1.Cells[i,n]:='';

  f2.loadfromfile('C:\1\aviasalon.tsv');
  for i:=1 to f2.count do begin
   ParseCSVStrEx(@u,f2.getstring(i),#9);
   if u.getstring(5)=' ' then begin
     if u.getstring(1)[1]='7' then begin clr:='<font color="#ff0000">'; clr1:='</font>'; expr:=''; end
                              else begin clr:=''; clr1:=''; expr:='';
                                     if u.getstring(1)[1]='0' then begin clr:='<font color="#bbbbbb">'; clr1:='</font>'; expr:='*'; end
                                     else begin clr:=''; clr1:=''; expr:=''; end;
                              end;
     if u.getstring(14)='3 ' then begin p1:='<u>'; p2:='</u>' end
                              else begin p1:=''; p1:=''; end;
     f3.add('<tr>');
     f3.add('    <td>'+clr+AviasalonSt(u.getstring(3),2)+clr1+'</td>');
     f3.add('    <td>'+clr+'<strong>'+u.getstring(13)+'</strong>'+clr1+'</td>');
     f3.add('    <td>'+clr+'<strong>'+u.getstring(12)+'</strong>'+clr1+'</td>');
     f3.add('    <td>'+clr+'&rarr;'+clr1+'</td>');
     f3.add('    <td>'+clr+''+u.getstring(11)+clr1+'</td>');
     f3.add('    <td><strong>'+clr+p1+u.getstring(10)+p2+clr1+'</strong></td>');
     f3.add('    <td>'+clr+''+u.getstring(9)+clr1+'</td>');
     f3.add('    <td>'+clr+''+u.getstring(8)+clr1+'</td>');
     f3.add('    <td><strong>'+clr+u.getstring(7)+clr1+'</strong></td>');
     f3.add('    <td>'+clr+''+expr+clr1+'</td>');
     f3.add('</tr>');
   end;
  end;
  f3.savetofile('C:\1\3.txt');
  showmessage('end!');

  f2.free; u.free; f3.free;
end;

procedure TForm1.Button7Click(Sender: TObject);
  var f1,f2,u:AF_Types.TStrings;
  var i,n:integer;
  var h1,h2,e1,e2,e3:string;
begin
 f1.create; f2.create; u.create;
 f1.loadfromfile('C:\1\29\borodino2018a.txt');
  for i:=1 to f1.count do begin
    h1:=''; h2:='';
    if pos(#9,f1.getstring(i))>0 then begin
      ParseCSVStrEx(@u,f1.getstring(i),#9);
      if u.count>2 then begin
       if u.getstring(15)='e' then begin
         e1:='';
         e2:='<font color="#0047ab">';
         e3:='</font>';
       end
        else begin
         e1:='';
         e2:='';
         e3:='';
        end;
       if u.getstring(16)='1' then begin
         f2.add('<tr>');
         f2.add('    <td><a href="https://rasp.yandex.ru/thread/'+u.getstring(6)+'">'+e2+u.getstring(2)+e3+'</a></td>');
         f2.add('    <td><strong>'+e2+u.getstring(7)+e3+'</strong></td>');
         f2.add('    <td>'+e2+u.getstring(8)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(9)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(10)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(11)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(12)+e3+'</td>');
         f2.add('    <td><strong>'+e2+u.getstring(13)+e3+'</strong></td>');
         f2.add('    <td><strong>'+e2+u.getstring(14)+e3+'</strong></td>');
         f2.add('    <td>'+e2+e1+e3+'</td>');
         f2.add('</tr>');
       end
        else begin
         f2.add('<tr>');
         f2.add('    <td><a href="https://rasp.yandex.ru/thread/'+u.getstring(6)+'">'+e2+u.getstring(2)+e3+'</a></td>');
         f2.add('    <td><strong>'+e2+u.getstring(14)+e3+'</strong></td>');
         f2.add('    <td><strong>'+e2+u.getstring(13)+e3+'</strong></td>');
         f2.add('    <td>'+e2+u.getstring(12)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(11)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(10)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(9)+e3+'</td>');
         f2.add('    <td>'+e2+u.getstring(8)+e3+'</td>');
         f2.add('    <td><strong>'+e2+u.getstring(7)+e3+'</strong></td>');
         f2.add('    <td>'+e2+e1+e3+'</td>');
         f2.add('</tr>');
        end;
      end;
    end;
  end;
 f2.savetofile('C:\1\29\borodino2018.txt');
 showmessage('end!');
 f1.free; f2.free; u.free;
end;

procedure TForm1.Button8Click(Sender: TObject);
 var tl:AF_Types.Tstrings;
 var i,n:integer;
 var s:string;
begin
  tl.create;
  tl.loadfromfile('C:\1\ 22\1.csv');
  if tl.count>0 then begin
   for i:=1 to tl.count do begin
    if validstr(tl.getstring(i)) then begin
     if fileexists('C:\1\ 22\'+tl.getstring(i)) then DeleteFile('C:\1\ 22\'+tl.getstring(i));
     s:=yserver+'/export/suburban/station/'+tl.getstring(i);
     GetInetFile(s,'C:\1\ 22\'+tl.getstring(i));
     sleep(1500);
    end;
   end;
   showmessage('!');
  end;
  tl.free;
end;

procedure TForm1.Button9Click(Sender: TObject);
  var fl:AF_Types.TStrings;
  var i:integer;
begin
  fl.create;
  GetMaskList('C:\1\ 22\*.xml',@fl);
  if fl.count>0 then begin
   for i:=1 to fl.count do begin
    if FileExists('C:\1\ 22\'+fl.getstring(i)+'.tmp') then deletefile('C:\1\ 22\'+fl.getstring(i)+'.tmp');
    UTF8FileDecode('C:\1\ 22\'+fl.getstring(i),'C:\1\ 22\'+fl.getstring(i)+'.tmp');
    XMLFile1('C:\1\ 22\'+fl.getstring(i)+'.tmp','C:\1\ 22\'+fl.getstring(i));
    if FileExists('C:\1\ 22\'+fl.getstring(i)+'.tmp') then deletefile('C:\1\ 22\'+fl.getstring(i)+'.tmp');
   end;
  end;
  showmessage('!');
  fl.free;
end;

procedure TForm1.Button10Click(Sender: TObject);
  var fl,f,uids,types,strs,excepts,numbers,titles:AF_Types.TStrings;
  var i,n:integer;
  var s,s1:string;
begin
  fl.create; f.create; uids.create; types.create; strs.create; excepts.create; numbers.create; titles.create;
  GetMaskList('C:\1\ 22\*.xml',@fl);
  if fl.count>0 then begin
   for i:=1 to fl.count do begin
     f.clear;
     f.loadfromfile('C:\1\ 22\'+fl.getstring(i));
     if f.count>0 then begin
      for n:=1 to f.count do begin
        s:=f.getstring(n);
        if pos('<thread',s)>0 then begin
          s1:=getParam('uid',s);
          if uids.searchstring(s1)<=0 then begin
            uids.add(s1);
            types.add(getParam('update',s));
            strs.add(getParam('days',s));
            excepts.add(getParam('except',s));
            numbers.add(getParam('number',s));
            titles.add(getParam('title',s));
          end;
        end;
      end;
     end;
   end;
  end;
  if uids.count>0 then begin
    f.clear;
    for i:=1 to uids.count do begin
      f.add(numbers.getstring(i)+#9+types.getstring(i)+#9+strs.getstring(i)+#9+excepts.getstring(i)+#9+uids.getstring(i)+#9+titles.getstring(i));
    end;
    f.savetofile('C:\1\ 22\out.txt');
  end;
  showmessage('!');
  fl.free; f.free; uids.free; types.free; strs.free; excepts.free; numbers.free; titles.free;
end;

procedure TForm1.Button11Click(Sender: TObject);
  var stl,dl:AF_Types.TStrings;
  var i,n:integer;
begin
  stl.create; dl.create;
  stl.add('191602'); // 
  stl.add('191424'); // 
  stl.add('195506'); // 
  stl.add('196004'); //  
  stl.add('195800'); //  
  stl.add('196108'); //  
  stl.add('196409'); //  
  stl.add('193519'); //  
  stl.add('193400'); //  
  stl.add('198103'); //  
  stl.add('194013'); //  
  stl.add('198230'); //  
  stl.add('181704'); //  
  dl.add('2013-03-11'); //
  dl.add('2013-03-12'); //
  dl.add('2013-03-13'); //
  dl.add('2013-03-14'); //
  dl.add('2013-03-15'); //
  dl.add('2013-03-16'); //
  dl.add('2013-03-17'); //
  dl.add('2013-04-22'); //
  dl.add('2013-04-23'); //
  dl.add('2013-04-24'); //
  dl.add('2013-04-25'); //
  dl.add('2013-04-26'); //
  dl.add('2013-04-27'); //
  dl.add('2013-04-28'); //
  for i:=1 to stl.count do begin
  for n:=1 to stl.count do begin
   GetInetFile(yserver+'/export/suburban/station/'+stl.getstring(i)+'?date='+dl.getstring(n),'C:\1\ 26\'+stl.getstring(i)+'_'+dl.getstring(n));
  end;
  end;
  stl.free; dl.free;
end;

procedure TForm1.Button12Click(Sender: TObject);
 var s:string;
begin
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
//  GetInetFile(yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1),workdir+'station1.xml.tmp');
  GetInetFile(yserver+'/export/suburban/station/061131',workdir+'station1.xml.tmp');
{  s:=yserver+'/export/suburban/station/61131?date=2013-07-05';
  InputQuery('','',s);}
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then ProcessFile_KonMoh;
   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 showmessage('!');
end;

procedure TForm1.Button13Click(Sender: TObject);
 var s:string;
begin
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
//  GetInetFile(yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1),workdir+'station1.xml.tmp');
  GetInetFile(yserver+'/export/suburban/station/194827?date=2021-07-23',workdir+'station1.xml.tmp');
{  s:=yserver+'/export/suburban/station/61131?date=2013-07-05';
  InputQuery('','',s);}
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then ProcessFile_Aviasalon;
   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 showmessage('!');
end;

procedure TForm1.Button14Click(Sender: TObject);
  var f,f1,u:AF_Types.TStrings;
  var i,n:integer;
begin
  f.create; f1.create; u.create;
  f.loadfromfile('C:\1\7.txt');

  f1.add(' 8 ');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.getstring(5)='' then begin
     if validstr(u.getstring(6)) then begin
         f1.add('  <tr>');
         f1.add('    <td class="tdstmw85"><a href="https://rasp.yandex.ru/thread/'+u.getstring(10)+'">'+u.getstring(9)+'</a></td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(11)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(12)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(13)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(14)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(15)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(16)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(17)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(18)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(19)+'</td>');
         f1.add('  </tr>');
     end;
    end;
  end;
  f1.add('');

  f1.add(' 9 ');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.getstring(5)='' then begin
     if validstr(u.getstring(7)) then begin
         f1.add('  <tr>');
         f1.add('    <td class="tdstmw85"><a href="https://rasp.yandex.ru/thread/'+u.getstring(10)+'">'+u.getstring(9)+'</a></td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(11)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(12)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(13)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(14)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(15)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(16)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(17)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(18)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(19)+'</td>');
         f1.add('  </tr>');
     end;
    end;
  end;
  f1.add('');

  f1.add(' 10 ');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.getstring(5)='' then begin
     if validstr(u.getstring(8)) then begin
         f1.add('  <tr>');
         f1.add('    <td class="tdstmw85"><a href="https://rasp.yandex.ru/thread/'+u.getstring(10)+'">'+u.getstring(9)+'</a></td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(11)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(12)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(13)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(14)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(15)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(16)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(17)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(18)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(19)+'</td>');
         f1.add('  </tr>');
     end;
    end;
  end;
  f1.add('');

  f1.add(' 9 ');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.getstring(5)='' then begin
     if validstr(u.getstring(7)) then begin
         f1.add('  <tr>');
         f1.add('    <td class="tdstmw85"><a href="https://rasp.yandex.ru/thread/'+u.getstring(10)+'">'+u.getstring(9)+'</a></td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(11)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(12)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(13)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(14)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(15)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(16)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(17)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(18)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(19)+'</td>');
         f1.add('  </tr>');
     end;
    end;
  end;
  f1.add('');

  f1.add(' 10 ');
  for i:=1 to f.count do begin
    ParseCSVStrEx(@u,f.getstring(i),#9);
    if u.getstring(5)='' then begin
     if validstr(u.getstring(8)) then begin
         f1.add('  <tr>');
         f1.add('    <td class="tdstmw85"><a href="https://rasp.yandex.ru/thread/'+u.getstring(10)+'">'+u.getstring(9)+'</a></td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(11)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(12)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(13)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(14)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(15)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(16)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(17)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(18)+'</td>');
         f1.add('    <td class="tdstmw45">'+u.getstring(19)+'</td>');
         f1.add('  </tr>');
     end;
    end;
  end;
  f1.add('');

  f1.savetofile('c:\1\km7out.html');

  f.free; f1.free; u.free;
end;

procedure TForm1.Button15Click(Sender: TObject);
 var i,n:integer;
 var s1:string;
begin
 mlog.clear;
 if combobox2.ItemIndex>=0 then begin
 for i:=0 to combobox2.items.count-1 do begin
  delay(1000);
  application.processmessages;
  combobox2.ItemIndex:=i;
  ForceDirectories(workdir+combobox1.items[combobox1.itemindex]);
//  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
//  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
//  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');

//  GetInetFile(yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1)+'?date=2018-08-26',workdir+'station1.xml.tmp');
  GetInetFile(yserverv2+'/export/v2/suburban/station/'+stc.getstring(combobox2.ItemIndex+1)+'?add_subtypes=true'+'&date=2019-06-29',workdir+'station1.xml.tmp');
  //    !
//  s1:=yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1);
//  InputQuery('','',s1);
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then begin
                                               ProcessFile_onDate_DirectionForAviasalon2;
                                             end;
//   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
//   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
//   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 end;
 mlog.savetofile(deleteslasheex(workdir+combobox1.items[combobox1.itemindex])+'\log.txt');
 showmessage('!');
 end;
end;

procedure TForm1.Button16Click(Sender: TObject);
 var i,n:integer;
 var s1:string;
begin
 mlog.clear;
 if combobox2.ItemIndex>=0 then begin
 for i:=0 to combobox2.items.count-1 do begin
  delay(1000);
  application.processmessages;
  combobox2.ItemIndex:=i;
  ForceDirectories(workdir+combobox1.items[combobox1.itemindex]);
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');

  GetInetFile(yserverv2+'/export/v2/suburban/station/'+stc.getstring(combobox2.ItemIndex+1){+'?date=2015-10-02'},workdir+'station1.xml.tmp');
  //        -  ProcessFile      !
  s1:=yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1);
//  InputQuery('','',s1);
  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then ProcessFile_Chg;
   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
  end
   else ShowMessage('          .      ,     !');
 end;
 mlog.savetofile(deleteslasheex(workdir+combobox1.items[combobox1.itemindex])+'\log.txt');
 showmessage('!');
 end;
end;

procedure TForm1.Button17Click(Sender: TObject);
begin
  if combobox2.ItemIndex>=0 then begin
  if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
  if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
  if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');

  GetInetFile(yserverv2+'/export/v2/suburban/station/'+stc.getstring(combobox2.ItemIndex+1){+'?date=2015-08-29'},workdir+'station1.xml.tmp');
  //        -  ProcessFile      !
//  s1:=yserver+'/export/suburban/station/'+stc.getstring(combobox2.ItemIndex+1);

  if fileexists(workdir+'station1.xml.tmp') then begin
   UTF8FileDecode(workdir+'station1.xml.tmp',workdir+'station2.xml.tmp');
   XMLFile1(workdir+'station2.xml.tmp',workdir+'station3.xml.tmp');
   if fileexists(workdir+'station3.xml.tmp') then begin
                                               ProcessFile_Chg;
                                             end;
//   if fileexists(workdir+'station1.xml.tmp') then DeleteFile(workdir+'station1.xml.tmp');
//   if fileexists(workdir+'station2.xml.tmp') then DeleteFile(workdir+'station2.xml.tmp');
//   if fileexists(workdir+'station3.xml.tmp') then DeleteFile(workdir+'station3.xml.tmp');
   showmessage('!');
  end
   else ShowMessage('          .      ,     !');
  end;
end;

end.
