USE hahn;

DEFINE ACTION $main($params) AS

    $date = $params['date'];
    $result_folder = '//home/travel-analytics/regular/hotels-marketshare/metrika-data/' || $date;

    $ya_travel_raw_data = (
        SELECT
            TableName() AS dt,
            UserID,
            if(IsMobile = True OR IsTablet = True, 'Тач', 'Десктоп') AS device_type,
        FROM
            RANGE(`//statbox/cooked_logs/visit-cooked-log/v1/1d`, $date, $date)
        WHERE
            1 = 1
            AND StartURL ilike '%travel.yandex.ru/hotels%'
            AND CounterID = 50912507
            AND (NOT IsRobot OR IsRobot IS NULL)
    );

    $ya_travel_data = (
        SELECT
            dt,
            count(*) AS visits,
            count(DISTINCT UserID) AS unique_users,
            device_type
        FROM
            $ya_travel_raw_data
        GROUP BY
            dt,
            device_type
    );

    $data = (
        SELECT
            CounterID,
            String::AsciiToLower(StartURL) AS StartURL,
            StartURLDomain,
            TableName() AS dt,
            if(IsMobile = True OR IsTablet = True, 'Тач', 'Десктоп') AS device_type,
            UserID
        FROM
            RANGE(`//statbox/cooked_logs/visit-cooked-private-log/v1/1d`, $date, $date)
        WHERE
            1 = 1
            AND CounterID in [4315831, 4315831, 4178746, 28356446, 6280015, 54662839, 20510308, 7293060, 81050341, 34784125, 8562148, 108917, 49682698, 5210767]
            AND (NOT IsRobot OR IsRobot IS NULL)
    );

    $hotels_data_filtered_with_n_hits=(
        SELECT
            Aggregate_list(distinct StartURLDomain),
            count(*) AS n_visits,
            count(distinct UserID) AS n_uniq_users,
            url,
            device_type,
            dt
        FROM
            $data
        WHERE
            1 = 1
            AND CounterID in [4315831, 4315831, 4178746, 28356446, 6280015, 54662839, 20510308, 7293060, 81050341, 34784125, 8562148, 108917, 49682698, 5210767]
            AND (
                StartURL ilike '%booking.com%'
                OR StartURL ilike '%travel.yandex.ru%hotels%'
                OR StartURL ilike '%hotellook.ru%'
                OR StartURL ilike '%pegast.ru%hotels%'
                OR StartURL ilike '%zabroniryi.ru%'
                OR StartURL ilike '%acase.ru%'
                OR StartURL ilike '%sutochno.ru%'
                OR StartURL ilike '%onetwotrip.com%ru%hotels%'
                OR StartURL ilike '%ozon.ru%travel%hotels%'
                OR StartURL ilike '%hotel.tutu.ru%'
                OR StartURL ilike '%tvil.ru%'
                OR (StartURL ilike '%ostrovok.ru%'
                            OR StartURL ilike '%tinkoff.ostrovok.ru%'
                            OR StartURL ilike '%b2b.ostrovok.ru%')
                OR (StartURL ilike '%ratehawk.com%'
                            OR StartURL ilike '%zenhotels.com%')
                OR (StartURL ilike '%101hotels.com%'
                                OR StartURL ilike '%m.101hotels.com%')
                OR (StartURL ilike '%bronevik.com%'
                                OR StartURL ilike '%secure.bronevik.com%')
                OR (StartURL ilike 'hotellook.ru'
                                OR StartURL ilike 'search.hotellook.ru')
                OR (StartURL ilike '%alean.ru%'
                                OR StartURL ilike '%www.alean.ru%')
                OR (StartURL ilike '%travel.ru%'
                                OR StartURL ilike '%hotelsearch.travel.ru%'))
        GROUP BY CASE
            WHEN StartURL ilike '%booking.com%' THEN 'Booking'
            WHEN StartURL ilike '%travel.yandex.ru/hotels%' THEN "Yandex Travel"
            WHEN StartURL ilike '%pegast.ru%hotels%' THEN "pegast"
            WHEN StartURL ilike '%zabroniryi.ru%' THEN "Zabroniryi"
            WHEN StartURL ilike '%acase.ru%' THEN "Acese"
            WHEN StartURL ilike '%sutochno.ru%' THEN "Sutochno"
            WHEN StartURL ilike '%onetwotrip.com%ru%hotels%' THEN "OneTwoTrip"
            WHEN StartURL ilike '%ozon.ru%travel%hotels%' THEN "Ozon.Travel"
            WHEN StartURL ilike '%hotel.tutu.ru%' THEN "Tutu"
            WHEN StartURL ilike '%tvil.ru%' THEN "Tvil"
            WHEN (StartURL ilike '%ostrovok.ru%'
                                or StartURL ilike '%tinkoff.ostrovok.ru%'
                                or StartURL ilike '%b2b.ostrovok.ru%') THEN "Ostrovok"
            WHEN (StartURL ilike '%ratehawk.com%'
                                or StartURL ilike '%zenhotels.com%') THEN "Ratehawk"
            WHEN (StartURL ilike '%101hotels.com%'
                                    or StartURL ilike '%m.101hotels.com%') THEN "101Hotels"
            WHEN (StartURL ilike '%bronevik.com%'
                                    or StartURL ilike '%secure.bronevik.com%') THEN "Bronevik"
            WHEN (StartURL ilike '%hotellook.ru%'
                                    or StartURL ilike 'search.hotellook.ru') THEN "Hotellook"
            WHEN (StartURL ilike '%alean.ru%'
                                    or StartURL ilike '%www.alean.ru%') THEN "Alean"
            WHEN (StartURL ilike '%travel.ru%'
                                    or StartURL ilike '%hotelsearch.travel.ru%') THEN "Travel.ru"
            ELSE 'other'
            END AS url,
            dt,
            device_type
        ORDER BY n_visits DESC
    );

    $result = (
        SELECT
            device_type,
            n_uniq_users,
            n_visits,
            dt,
            url
        FROM
            $hotels_data_filtered_with_n_hits

        UNION ALL

        SELECT
            device_type,
            unique_users AS n_uniq_users,
            visits AS n_visits,
            dt,
            'Yandex Travel' AS url
        FROM
            $ya_travel_data
    );

    SELECT *
    FROM
        $result;

    INSERT INTO $result_folder
        WITH TRUNCATE
    SELECT *
    FROM
        $result
    ORDER BY
        dt,
        url,
        device_type;

END DEFINE;