from yt.wrapper import YtClient
import yt.wrapper as yt
from yt.wrapper.cli_helpers import die
from datetime import datetime, timedelta
import sys
import traceback

paths = ['//home/travel-analytics/aantropova/tmp',
         '//home/travel-analytics/dshashin/tmp',
         '//home/travel/markliubimov/nirvana',
         '//home/travel/al-s-zhukov/nirvana',
         '//home/travel/analytics/kateov/nirvana',
         '//home/travel-analytics/sshlim/metrika/train']

dt = (datetime.today() - timedelta(days=3)).strftime('%Y-%m-%d')
client = YtClient("hahn")
batch_client = client.create_batch_client()
yt_client = YtClient(proxy="hahn", )


def delete_node(path, node, time=dt):
    if node.attributes['type'] == 'map_node':
        if len(node.keys()) == 0 and (path not in paths):
            batch_client.remove(path)
            return 0
        for key in node.keys():
            delete_node(path + '/' + key ,node[key], time)

    if (node.attributes['modification_time']) < time and (path not in paths):
        print(path)
        batch_client.remove(path)


def main():
    for path in paths:
        node = yt_client.get(path, attributes=['owner', 'access_time', 'modification_time', 'type'])
        for _ in range(3):
            delete_node(path, node, dt)
            batch_client.commit_batch()


if __name__ == "__main__":
    try:
        main()
    except yt.YtError as error:
        die(str(error))
    except Exception:
        traceback.print_exc(file=sys.stderr)
        die()
