
$get_source_2 = ($source, $medium, $TraficSourceID, $SearchEngineID) -> {
    return case 
            when $source == 'direct_empty' or ($source == 'yandex' and $medium == 'search') then 'yandex_search'
            when $source == 'adwords_empty' or ($source == 'google' and $medium == 'search')  then 'google_search'
            when $source == 'yandex' and $medium == 'rsya' then 'yandex_rsya'
            when $source == 'google' and $medium == 'gdn' then 'google_gdn'
            when $source == 'yandex' and $medium == 'mkb' then 'other_paid'
            
            when ($source is null or $source != 'main_stripe_big') and $medium == 'cpa' 
                then 'affiliate_'||if(($source??'') in ('admitad', 'distribution', 'edadeal', 'perfluence', 'travelpayouts'), $source, 'other')
            when $source in ('yamain', 'serp', 'services', 'distribution', 'bottomsheet', 'homescreen', 'main_stripe_big', 'navpanel') then 'YaPortal'
            when $source in ('mt', 'vk', 'fb', 'ig', 'ok') then 'other_paid'
            when String::Contains($source, 'wizard') then 'Wizard'
            when String::Contains($source, 'maps') then 'Maps'
            when $source in ('rasp', 'informer', 'suburbans') then 'Rasp'
            when $source == 'yandex_organic' then 'yandex_organic'
            when $source == 'google_organic' then 'google_organic'
            when $medium == 'pr' then 'PR/media'
            when $source in ('avia', 'yabus', 'travel-portal') then 'travel'
            when $TraficSourceID=7 -- тип трафика по метрике
                or $source in ('plus_ru', -- трафик из веб домика плюса
                    'plus-sdk', -- трафик из апп домика плюса
                    'plus', -- остальная активность плюса (в осноном спец промики)
                    'email') -- новые метки писем
                or $medium == 'email' -- старые метки писем
            THEN 'CRM'

            -- https://wiki.yandex-team.ru/jandexmetrika/data/metrikatables/visits/searchengineid/
            WHEN $TraficSourceID=2 and $SearchEngineID IN (1, 2, 13, 74, 75, 124, 181, 212) THEN 'yandex_organic' --
            WHEN $TraficSourceID=2 and $SearchEngineID in (3, 224) THEN 'google_organic' 
            WHEN $TraficSourceID=2 THEN 'other_organic' 
        
        --     WHEN $TraficSourceID=0 THEN 'Прямые заходы'
        --     WHEN $TraficSourceID=1 THEN 'По ссылкам на сайтах' 
        --     WHEN $TraficSourceID=-1 THEN 'Внутренние переходы'
        --     WHEN $TraficSourceID=3 THEN 'other_paid'  -- 'Переходы по рекламе'
        -- --    WHEN $TraficSourceID=4 THEN 'Переходы с сохранённых страниц'
        -- --    WHEN $TraficSourceID=5 THEN 'Не определён'
        -- --    WHEN $TraficSourceID=6 THEN 'Переходы по внешним ссылкам'
        --     WHEN $TraficSourceID=8 THEN 'PR/media'  -- 'Переходы из социальных сетей'
        -- --    WHEN $TraficSourceID=9 THEN 'Переходы из рекомендательных систем'
        --     WHEN $TraficSourceID=10 THEN 'PR/media' -- 'Переходы из мессенджеров' 
            WHEN $source is null and $medium is null THEN 'Прямые заходы' 
            else 'Other'
        end;
};

$get_source_1 = ($source2) -> {
    return if($source2 in ('yandex_search', 'google_search', 'yandex_rsya', 'google_gdn', 'other_paid'), 'Paid', 
        if($source2 in ('yandex_organic', 'google_organic', 'other_organic'), 'Organic', 
        if(String::StartsWith($source2, 'affiliate'), 'Affiliate', 
        $source2))
        );
};


$__hotels_boy_partners = (
    SELECT
        TableRow() as t
    FROM (
        SELECT
            AGGREGATE_LIST(PartnerId) AS partners
        FROM
            hahn.`//home/travel/prod/config/partners`
        WHERE
            IsBoY=true OR IsBoYDirect=true
    )
);

$hotels_boy_partners = () -> {
    RETURN $__hotels_boy_partners.partners;
};

EXPORT $get_source_2, $get_source_1, $hotels_boy_partners;
