#include "ru_yandex_travel_api_services_localization_Inflector.h"

#include "handle.h"

#include <kernel/inflectorlib/phrase/simple/simple.h>
#include <library/cpp/langs/langs.h>

#include <util/system/compiler.h>

#include <iostream>

JNIEXPORT void Java_ru_yandex_travel_api_services_localization_Inflector_initialize(JNIEnv* env, jobject obj) {
    auto inflector = new NInfl::TSimpleInflector(NameByLanguage(LANG_RUS));
    setHandle(env, obj, inflector);
}

JNIEXPORT jstring JNICALL Java_ru_yandex_travel_api_services_localization_Inflector_inflect(JNIEnv* env, jobject obj, jstring text, jstring gram) {
    auto inflector = getHandle<NInfl::TSimpleInflector>(env, obj);
    try {
        const TUtf16String textStr = TUtf16String::FromUtf8(env->GetStringUTFChars(text, nullptr));
        const char* gramStr = env->GetStringUTFChars(gram, nullptr);
        const TUtf16String inflectedStr = inflector->Inflect(textStr, gramStr);
        return env->NewString(reinterpret_cast<const jchar*>(inflectedStr.data()), inflectedStr.length());
    } catch (...) {
        // See https://stackoverflow.com/a/15289742
        jclass ex_class = env->FindClass("ru/yandex/travel/api/services/localization/InflectorException");
        if (ex_class) {
            env->ThrowNew(ex_class, CurrentExceptionMessage().c_str());
        }
        return nullptr;
    }
}

JNIEXPORT void JNICALL Java_ru_yandex_travel_api_services_localization_Inflector_dispose(JNIEnv* env, jobject obj) {
    auto inflector = getHandle<NInfl::TSimpleInflector>(env, obj);
    clearHandle(env, obj);
    delete inflector;
}
