package ru.yandex.travel.api;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Import;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import ru.yandex.travel.hotels.busbroker.BusBrokerConfiguration;
import ru.yandex.travel.hotels.services.promoservice.PromoServiceConfiguration;
import ru.yandex.travel.infrastructure.ConfigProcessorApplicationListener;
import ru.yandex.travel.natives.Natives;

@SpringBootApplication
@EnableSwagger2
@Slf4j
@Import({
        BusBrokerConfiguration.class,
})
@ImportAutoConfiguration(PromoServiceConfiguration.class)
public class Application {
    public static void main(String[] args) {
        if (Boolean.parseBoolean(System.getenv("LOCK_MEMORY"))) {
            log.info("Locking virtual memory pages to RAM");
            Natives.tryMlockall();
        }
        var springApplication = new SpringApplication(Application.class);
        springApplication.addListeners(new ConfigProcessorApplicationListener());
        springApplication.run(args);
    }
}
