package ru.yandex.travel.api.config.avia;

import java.time.Clock;

import io.opentracing.Tracer;
import lombok.extern.slf4j.Slf4j;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.avia.booking.partners.gateways.aeroflot.AeroflotGateway;
import ru.yandex.avia.booking.partners.gateways.aeroflot.AeroflotProviderProperties;
import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;

@Configuration
@ConditionalOnBean(AviaBookingConfiguration.class)
@Slf4j
public class AeroflotGatewayConfiguration {
    @Bean
    @ConfigurationProperties(value = "aeroflot", ignoreUnknownFields = false)
    @Validated
    public AeroflotProviderProperties aeroflotProviderProperties() {
        return new AeroflotProviderProperties();
    }

    @Bean
    @ConfigurationProperties(value = "aeroflot-ahc-client", ignoreUnknownFields = false)
    public DefaultAsyncHttpClientConfig.Builder aeroflotAhcConfig() {
        return Dsl.config().setThreadPoolName("aeroflotAhc");
    }

    @Bean
    public AsyncHttpClient aeroflotAhcImpl(DefaultAsyncHttpClientConfig.Builder aeroflotAhcConfig) {
        return Dsl.asyncHttpClient(aeroflotAhcConfig);
    }

    @Bean
    public AsyncHttpClientWrapper aeroflotAhc(AsyncHttpClient aeroflotAhcImpl,
                                              Tracer tracer) {
        return new AsyncHttpClientWrapper(
                aeroflotAhcImpl,
                LoggerFactory.getLogger("ru.yandex.travel.api.config.avia.aeroflot.HttpLogger"),
                "aeroflot",
                tracer,
                null
        );
    }

    @Bean
    @Autowired
    public AeroflotGateway aeroflotGateway(
            AeroflotProviderProperties config,
            AsyncHttpClientWrapper aeroflotAhc,
            Clock clock
    ) {
        return new AeroflotGateway(config, aeroflotAhc, clock);
    }
}
