package ru.yandex.travel.api.config.avia;

import io.opentracing.Tracer;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

import ru.yandex.avia.booking.services.tdapi.AviaTicketDaemonApiClient;
import ru.yandex.avia.booking.services.tdapi.AviaTicketDaemonApiProperties;
import ru.yandex.travel.api.services.avia.api_gateway.AviaApiGatewayService;
import ru.yandex.travel.api.services.avia.api_gateway.AviaApiGatewayServiceProperties;
import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.tvm.TvmWrapper;

@Configuration
@ConditionalOnBean(AviaBookingConfiguration.class)
public class AviaApiClientsConfiguration {
    @Bean
    @ConfigurationProperties(value = "avia-apis.default-ahc", ignoreUnknownFields = false)
    public DefaultAsyncHttpClientConfig.Builder aviaApisDefaultAhcConfig() {
        return Dsl.config().setThreadPoolName("aviaApisDefaultAhc");
    }

    @Bean
    public AsyncHttpClient aviaApisDefaultAhcImpl(DefaultAsyncHttpClientConfig.Builder aviaApisDefaultAhcConfig) {
        return Dsl.asyncHttpClient(aviaApisDefaultAhcConfig);
    }

    @Bean
    public AsyncHttpClientWrapper aviaApisDefaultAhc(AsyncHttpClient aviaApisDefaultAhcImpl,
                                                     Tracer tracer) {
        return new AsyncHttpClientWrapper(
                aviaApisDefaultAhcImpl,
                LoggerFactory.getLogger("ru.yandex.travel.api.config.avia.apis.HttpLogger"),
                "avia-apis",
                tracer,
                null
        );
    }

    @Bean
    @ConfigurationProperties(value = "avia-apis.td-api", ignoreUnknownFields = false)
    @Validated
    public AviaTicketDaemonApiProperties aviaTicketDaemonApiProperties() {
        return new AviaTicketDaemonApiProperties();
    }

    @Bean
    public AviaTicketDaemonApiClient aviaTicketDaemonApiClient(
            AsyncHttpClientWrapper aviaApisDefaultAhc,
            @Autowired(required = false) TvmWrapper tvm,
            AviaTicketDaemonApiProperties config
    ) {
        return new AviaTicketDaemonApiClient(aviaApisDefaultAhc, tvm, config);
    }

    @Bean
    @ConfigurationProperties(value = "avia-apis.api-gateway", ignoreUnknownFields = false)
    @Validated
    public AviaApiGatewayServiceProperties aviaApiGatewayServiceProperties() {
        return new AviaApiGatewayServiceProperties();
    }

    @Bean
    public AviaApiGatewayService aviaApiGatewayService(
            AsyncHttpClientWrapper aviaApisDefaultAhc,
            AviaApiGatewayServiceProperties config
    ) {
        return new AviaApiGatewayService(aviaApisDefaultAhc, config);
    }
}
