package ru.yandex.travel.api.config.avia;

import com.google.common.collect.ImmutableMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import ru.yandex.avia.booking.partners.gateways.aeroflot.AeroflotGateway;
import ru.yandex.travel.api.services.avia.AviaBookingProviderResolver;

@Configuration
@ConditionalOnBean(AviaBookingConfiguration.class)
public class AviaBookingProviderResolverConfiguration {
    @Bean
    public AviaBookingProviderResolver bookingGatewayResolver(Environment environment,
                                                              AeroflotGateway aeroflotGateway) {
        return new AviaBookingProviderResolver(
                environment,
                ImmutableMap.of(AeroflotGateway.AEROFLOT_PARTNER_ID, aeroflotGateway)
        );
    }
}
