package ru.yandex.travel.api.config.avia;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.services.avia.fares.AviaFareFamilyProperties;
import ru.yandex.travel.api.services.avia.fares.AviaFareFamilyReference;
import ru.yandex.travel.api.services.avia.fares.AviaFareFamilyReferenceParser;

@Configuration
public class AviaFareFamilyReferenceConfiguration {
    @Bean
    @ConfigurationProperties("avia-fares")
    public AviaFareFamilyProperties fareFamilyProperties() {
        return new AviaFareFamilyProperties();
    }

    @Bean
    public AviaFareFamilyReference fareFamilyReference(AviaFareFamilyProperties properties) {
        return new AviaFareFamilyReference(
                AviaFareFamilyReferenceParser.loadFareFamilies(properties.getFareFamiliesFile()),
                AviaFareFamilyReferenceParser.loadExternalExpressions(properties.getExternalExpressionsFile())
        );
    }
}
