package ru.yandex.travel.api.config.avia;

import java.util.Map;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.config.common.GeoBaseConfigurationProperties;
import ru.yandex.travel.api.services.avia.references.AviaGeobaseCountryService;
import ru.yandex.travel.api.services.avia.references.AviaGeobaseCountryServiceImpl;
import ru.yandex.travel.api.services.hotels.geobase.GeoBase;

@Configuration
@EnableConfigurationProperties(GeoBaseConfigurationProperties.class)
public class AviaGeobaseCountryServiceConfiguration {

    @Bean
    @ConditionalOnProperty(name = "geobase.enabled", havingValue = "true")
    public AviaGeobaseCountryService geobaseCountryService(GeoBase geoBase) {
        return new AviaGeobaseCountryServiceImpl(geoBase);
    }

    @Bean
    @ConditionalOnMissingBean(AviaGeobaseCountryService.class)
    public AviaGeobaseCountryService mockGeobaseCountryService() {
        return new AviaGeobaseCountryService() {
            @Override
            public String getIsoName(Integer regionId) {
                throw new RuntimeException("Avia geobase is disabled");
            }

            @Override
            public Integer getCountryGeoId(String countryIsoCode) {
                throw new RuntimeException("Avia geobase is disabled");
            }

            @Override
            public Map<String, Integer> collectCountryCodesMapping() {
                throw new RuntimeException("Avia geobase is disabled");
            }
        };
    }

}
