package ru.yandex.travel.api.config.common;

import io.opentracing.Tracer;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.hotels.common.partners.bnovo.DefaultBNovoClient;
import ru.yandex.travel.hotels.common.partners.dolphin.DefaultDolphinClient;
import ru.yandex.travel.hotels.common.partners.expedia.DefaultExpediaClient;
import ru.yandex.travel.hotels.common.partners.travelline.DefaultTravellineClient;

@Configuration
public class AhcConfiguration {
    public static Logger DEFAULT_HTTP_LOGGER = LoggerFactory.getLogger("ru.yandex.travel.api.HttpLogger");

    @Bean
    public AsyncHttpClient defaultAhcClient() {
        return Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName("ahcPool")
                .build());
    }

    @Bean
    public AsyncHttpClientWrapper expediaAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient,
                DEFAULT_HTTP_LOGGER, "expedia", tracer, DefaultExpediaClient.getMethods().getNames());
    }

    @Bean
    public AsyncHttpClientWrapper ugcAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "ugc", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper geoSuggestAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "geosuggest", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper hotelSuggestAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "hotelsuggest", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper hotelRedirAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "hotel-redir", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper trainsProxyAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "trains-api-proxy", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper aviaProxyAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "avia-api-proxy", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper dolphinAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient,
                DEFAULT_HTTP_LOGGER, "dolphin", tracer, DefaultDolphinClient.getMethods().getNames());
    }

    @Bean
    public AsyncHttpClientWrapper travellineAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient,
                DEFAULT_HTTP_LOGGER, "travelline", tracer, DefaultTravellineClient.getMethods().getNames());
    }

    @Bean
    public AsyncHttpClientWrapper bNovoAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient,
                DEFAULT_HTTP_LOGGER, "bnovo", tracer, DefaultBNovoClient.getMethods().getNames());
    }

    @Bean
    public AsyncHttpClientWrapper mordaBackendAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "morda-backend", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper busAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "bus", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper afishaAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "afisha", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper weatherAsyncHttpClientWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "weather", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper iziTravelAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "izi-travel", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper pdfAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "pdfGenerator", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper trainHttpProxyCacheAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
       return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "train-http-proxy-cache", tracer, null);
    }

    @Bean
    public AsyncHttpClientWrapper trainCrosslinkAhcWrapper(AsyncHttpClient defaultAhcClient, Tracer tracer) {
        return new AsyncHttpClientWrapper(defaultAhcClient, DEFAULT_HTTP_LOGGER, "train-crosslink", tracer, null);
    }
}
