package ru.yandex.travel.api.config.common;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.hotels.common.encryption.EncryptionService;

@Configuration
@EnableConfigurationProperties(EncryptionConfigurationProperties.class)
public class EncryptionConfiguration {
    @Bean
    public EncryptionService getEncryptionService(EncryptionConfigurationProperties properties) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return new EncryptionService(properties.getEncryptionKey());
    }

}
