package ru.yandex.travel.api.config.common;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.services.hotels.geobase.GeoBase;
import ru.yandex.travel.api.services.hotels.geobase.LookupGeoBase;

@Configuration
@EnableConfigurationProperties(GeoBaseConfigurationProperties.class)
public class GeoBaseConfiguration {
    @Bean
    public GeoBase geobase(GeoBaseConfigurationProperties properties) {
        return new LookupGeoBase(properties.isEnabled(), properties.getGeobaseFile());
    }
}
