package ru.yandex.travel.api.config.common;

import com.fasterxml.jackson.databind.Module;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.api.models.hotels.converters.BoundingBoxSerializersModule;
import ru.yandex.travel.api.models.hotels.converters.PermalinkSerializersModule;
import ru.yandex.travel.commons.jackson.MoneySerializersModule;

@Configuration
public class JacksonConfiguration {

    @Bean
    public Module moneySerializersModule() {
        // customizing rest api json serializer
        return new MoneySerializersModule();
    }

    @Bean
    public Module protobufSerializatorsModule() {
        // customizing rest api json serializer
        return new ProtobufModule();
    }

    @Bean
    public Module permalinkSerializersModule() {
        // customizing rest api json serializer
        return new PermalinkSerializersModule();
    }

    @Bean
    public Module boundingBoxSerializersModule() {
        // customizing rest api json serializer
        return new BoundingBoxSerializersModule();
    }
}
