package ru.yandex.travel.api.config.common;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;

@Configuration
public class JdbcConfiguration {
    @Bean
    @Primary
    public JdbcTemplate getJdbcTemplate(@Autowired DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(dataSource);

        if (dataSource == null) {
            return jdbcTemplate;
        }

        SQLErrorCodeSQLExceptionTranslator sqlExceptionTranslator = new SQLErrorCodeSQLExceptionTranslator();
        sqlExceptionTranslator.setDataSource(dataSource);

        jdbcTemplate.setExceptionTranslator(sqlExceptionTranslator);

        return jdbcTemplate;
    }
}
