package ru.yandex.travel.api.config.common;

import org.eclipse.jetty.server.Slf4jRequestLog;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
public class JettyAccessLogConfiguration {
    @Bean
    public WebServerFactoryCustomizer getCustomizer() {
        return new OrderedCustomizer();
    }

    class OrderedCustomizer implements WebServerFactoryCustomizer, Ordered {
        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public void customize(WebServerFactory factory) {
            Slf4jRequestLog logger = new Slf4jRequestLog();
            logger.setLogLatency(true);
            logger.setLoggerName("ru.yandex.travel.api.AccessLog");
            JettyServletWebServerFactory f = (JettyServletWebServerFactory) factory;
            f.addServerCustomizers((JettyServerCustomizer) server -> server.setRequestLog(logger));
        }
    }


}
