package ru.yandex.travel.api.config.common;

import java.lang.reflect.Type;

import javax.servlet.http.HttpServletRequest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.lang.Nullable;

//TODO set camelCase as default in properties, use snake_case for IDM when https://st.yandex-team.ru/HOTELS-4639 is finished
@Configuration
@ConditionalOnProperty("conditional-naming.enabled")
public class NamingStrategyConfiguration {

    public static class ConditionalCamelCaseHttpMessageConverter extends MappingJackson2HttpMessageConverter {

        public static final String CAMEL_CASE_HEADER = "X-Ya-UseCamelCase";
        private final HttpServletRequest request;

        public ConditionalCamelCaseHttpMessageConverter(ObjectMapper objectMapper, HttpServletRequest request) {
            super(objectMapper);
            this.request = request;
        }

        private boolean canBeUsed() {
            return request != null && "true".equals(request.getHeader(CAMEL_CASE_HEADER));
        }

        @Override
        public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
            if (canBeUsed()) {
                return super.canWrite(clazz, mediaType);
            } else {
                return false;
            }
        }

        @Override
        public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
            if (canBeUsed()) {
                return super.canRead(type, contextClass, mediaType);
            } else {
                return false;
            }
        }

    }

    @Bean
    public ConditionalCamelCaseHttpMessageConverter conditionalCamleCaseConverter(Jackson2ObjectMapperBuilder objectMapperBuilder, HttpServletRequest request) {
        ObjectMapper objectMapper = objectMapperBuilder.build();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        return new ConditionalCamelCaseHttpMessageConverter(objectMapper, request);
    }

    @Bean
    public MappingJackson2HttpMessageConverter classicalConverter(
            ObjectMapper objectMapper) {
        return new MappingJackson2HttpMessageConverter(objectMapper);
    }

}
