package ru.yandex.travel.api.config.common;

import com.google.common.collect.ImmutableList;
import io.sentry.spring.SentryServletContextInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;

@Configuration
public class SentryConfiguration {

    @Bean
    public StackTraceFingerprinter stackTraceFingerprinter() {
        // TODO mbobrov: parameterize package prefixes
        return new StackTraceFingerprinter(ImmutableList.of("ru.yandex"));
    }

    @Bean
    @Autowired
    public HandlerExceptionResolver sentryExceptionResolver(StackTraceFingerprinter stackTraceFingerprinter) {
        return new SentryExceptionResolver(stackTraceFingerprinter);
    }

    @Bean
    public ServletContextInitializer sentryServletContextInitializer() {
        return new SentryServletContextInitializer();
    }
}
